/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.preprocess.ContentModifier;

class PatternReplacingContentModifier
implements ContentModifier {
    private final Pattern pattern;
    private final String replacement;
    private final Charset fallbackCharset;

    PatternReplacingContentModifier(Pattern pattern, String replacement) {
        this(pattern, replacement, Charset.defaultCharset());
    }

    PatternReplacingContentModifier(Pattern pattern, String replacement, Charset fallbackCharset) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.fallbackCharset = fallbackCharset;
    }

    @Override
    public byte[] modifyContent(byte[] content, MediaType contentType) {
        Charset charset = contentType != null && contentType.getCharset() != null ? contentType.getCharset() : this.fallbackCharset;
        String original = new String(content, charset);
        Matcher matcher = this.pattern.matcher(original);
        StringBuilder builder = new StringBuilder();
        int previous = 0;
        while (matcher.find()) {
            String prefix;
            if (matcher.groupCount() > 0) {
                prefix = original.substring(previous, matcher.start(1));
                previous = matcher.end(1);
            } else {
                prefix = original.substring(previous, matcher.start());
                previous = matcher.end();
            }
            builder.append(prefix);
            builder.append(this.replacement);
        }
        if (previous < original.length()) {
            builder.append(original.substring(previous));
        }
        return builder.toString().getBytes(charset);
    }
}

