/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldTypeResolver;
import org.springframework.restdocs.payload.JsonContentHandler;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.XmlContentHandler;

interface ContentHandler
extends FieldTypeResolver {
    public List<FieldDescriptor> findMissingFields();

    public String getUndocumentedContent();

    public static ContentHandler forContentWithDescriptors(byte[] content, MediaType contentType, List<FieldDescriptor> descriptors) {
        try {
            return new JsonContentHandler(content, descriptors);
        }
        catch (Exception je) {
            try {
                return new XmlContentHandler(content, descriptors);
            }
            catch (Exception xe) {
                throw new PayloadHandlingException("Cannot handle " + contentType + " content as it could not be parsed as JSON or XML");
            }
        }
    }
}

