/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.JsonContentHandler;
import org.springframework.restdocs.payload.JsonFieldPath;
import org.springframework.restdocs.payload.JsonFieldPaths;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.PayloadSubsectionExtractor;

public class FieldPathPayloadSubsectionExtractor
implements PayloadSubsectionExtractor<FieldPathPayloadSubsectionExtractor> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectMapper prettyPrintingOjectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final String fieldPath;
    private final String subsectionId;

    protected FieldPathPayloadSubsectionExtractor(String fieldPath) {
        this(fieldPath, "beneath-" + fieldPath);
    }

    protected FieldPathPayloadSubsectionExtractor(String fieldPath, String subsectionId) {
        this.fieldPath = fieldPath;
        this.subsectionId = subsectionId;
    }

    @Override
    public byte[] extractSubsection(byte[] payload, MediaType contentType) {
        return this.extractSubsection(payload, contentType, Collections.emptyList());
    }

    @Override
    public byte[] extractSubsection(byte[] payload, MediaType contentType, List<FieldDescriptor> descriptors) {
        try {
            JsonFieldProcessor.ExtractedField extractedField = new JsonFieldProcessor().extract(this.fieldPath, objectMapper.readValue(payload, Object.class));
            Object value = extractedField.getValue();
            if (value == JsonFieldProcessor.ExtractedField.ABSENT) {
                throw new PayloadHandlingException(this.fieldPath + " does not identify a section of the payload");
            }
            Map<JsonFieldPath, FieldDescriptor> descriptorsByPath = descriptors.stream().collect(Collectors.toMap(descriptor -> JsonFieldPath.compile(this.fieldPath + "." + descriptor.getPath()), this::prependFieldPath));
            if (value instanceof List) {
                List extractedList = (List)value;
                if (extractedList.isEmpty()) {
                    throw new PayloadHandlingException(this.fieldPath + " identifies an empty section of the payload");
                }
                JsonContentHandler contentHandler = new JsonContentHandler(payload, descriptorsByPath.values());
                Set uncommonPaths = JsonFieldPaths.from(extractedList).getUncommon().stream().map(path -> JsonFieldPath.compile((String)(path.equals("") ? this.fieldPath : this.fieldPath + "." + path))).filter(path -> {
                    FieldDescriptor descriptorForPath = descriptorsByPath.getOrDefault(path, new FieldDescriptor(path.toString()));
                    return contentHandler.isMissing(descriptorForPath);
                }).collect(Collectors.toSet());
                if (uncommonPaths.isEmpty()) {
                    value = extractedList.get(0);
                } else {
                    String message = this.fieldPath + " identifies multiple sections of the payload and they do not have a common structure. The following non-optional uncommon paths were found: ";
                    message = message + uncommonPaths.stream().map(JsonFieldPath::toString).collect(Collectors.toCollection(TreeSet::new));
                    throw new PayloadHandlingException(message);
                }
            }
            return this.getObjectMapper(payload).writeValueAsBytes(value);
        }
        catch (IOException ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    private FieldDescriptor prependFieldPath(FieldDescriptor original) {
        FieldDescriptor prefixed = new FieldDescriptor(this.fieldPath + "." + original.getPath());
        if (original.isOptional()) {
            prefixed.optional();
        }
        return prefixed;
    }

    @Override
    public String getSubsectionId() {
        return this.subsectionId;
    }

    protected String getFieldPath() {
        return this.fieldPath;
    }

    @Override
    public FieldPathPayloadSubsectionExtractor withSubsectionId(String subsectionId) {
        return new FieldPathPayloadSubsectionExtractor(this.fieldPath, subsectionId);
    }

    private ObjectMapper getObjectMapper(byte[] payload) {
        if (this.isPrettyPrinted(payload)) {
            return prettyPrintingOjectMapper;
        }
        return objectMapper;
    }

    private boolean isPrettyPrinted(byte[] payload) {
        for (byte b : payload) {
            if (b != 10) continue;
            return true;
        }
        return false;
    }
}

