/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JsonFieldPath {
    private static final Pattern BRACKETS_AND_ARRAY_PATTERN = Pattern.compile("\\['(.+?)'\\]|\\[([0-9]+|\\*){0,1}\\]");
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("\\[([0-9]+|\\*){0,1}\\]");
    private final String rawPath;
    private final List<String> segments;
    private final PathType type;

    private JsonFieldPath(String rawPath, List<String> segments, PathType type) {
        this.rawPath = rawPath;
        this.segments = segments;
        this.type = type;
    }

    PathType getType() {
        return this.type;
    }

    List<String> getSegments() {
        return this.segments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonFieldPath other = (JsonFieldPath)obj;
        return this.segments.equals(other.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return this.rawPath;
    }

    static JsonFieldPath compile(String path) {
        List<String> segments;
        return new JsonFieldPath(path, segments, JsonFieldPath.matchesSingleValue(segments = JsonFieldPath.extractSegments(path)) ? PathType.SINGLE : PathType.MULTI);
    }

    static boolean isArraySegment(String segment) {
        return ARRAY_INDEX_PATTERN.matcher(segment).matches();
    }

    static boolean matchesSingleValue(List<String> segments) {
        Iterator<String> iterator = segments.iterator();
        while (iterator.hasNext()) {
            String segment = iterator.next();
            if ((!JsonFieldPath.isArraySegment(segment) || !iterator.hasNext()) && !JsonFieldPath.isWildcardSegment(segment)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWildcardSegment(String segment) {
        return "*".equals(segment);
    }

    private static List<String> extractSegments(String path) {
        Matcher matcher = BRACKETS_AND_ARRAY_PATTERN.matcher(path);
        int previous = 0;
        ArrayList<String> segments = new ArrayList<String>();
        while (matcher.find()) {
            if (previous != matcher.start()) {
                segments.addAll(JsonFieldPath.extractDotSeparatedSegments(path.substring(previous, matcher.start())));
            }
            if (matcher.group(1) != null) {
                segments.add(matcher.group(1));
            } else {
                segments.add(matcher.group());
            }
            previous = matcher.end(0);
        }
        if (previous < path.length()) {
            segments.addAll(JsonFieldPath.extractDotSeparatedSegments(path.substring(previous)));
        }
        return segments;
    }

    private static List<String> extractDotSeparatedSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        for (String segment : path.split("\\.")) {
            if (segment.length() <= 0) continue;
            segments.add(segment);
        }
        return segments;
    }

    static enum PathType {
        SINGLE,
        MULTI;

    }
}

