/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.operation.FormParameters;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.request.AbstractParametersSnippet;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.snippet.SnippetException;

public class FormParametersSnippet
extends AbstractParametersSnippet {
    protected FormParametersSnippet(List<ParameterDescriptor> descriptors) {
        this(descriptors, null, false);
    }

    protected FormParametersSnippet(List<ParameterDescriptor> descriptors, boolean ignoreUndocumentedParameters) {
        this(descriptors, null, ignoreUndocumentedParameters);
    }

    protected FormParametersSnippet(List<ParameterDescriptor> descriptors, Map<String, Object> attributes) {
        this(descriptors, attributes, false);
    }

    protected FormParametersSnippet(List<ParameterDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedParameters) {
        super("form-parameters", descriptors, attributes, ignoreUndocumentedParameters);
    }

    @Override
    protected void verificationFailed(Set<String> undocumentedParameters, Set<String> missingParameters) {
        Object message = "";
        if (!undocumentedParameters.isEmpty()) {
            message = (String)message + "Form parameters with the following names were not documented: " + undocumentedParameters;
        }
        if (!missingParameters.isEmpty()) {
            if (((String)message).length() > 0) {
                message = (String)message + ". ";
            }
            message = (String)message + "Form parameters with the following names were not found in the request: " + missingParameters;
        }
        throw new SnippetException((String)message);
    }

    @Override
    protected Set<String> extractActualParameters(Operation operation) {
        return FormParameters.from(operation.getRequest()).keySet();
    }

    public FormParametersSnippet and(ParameterDescriptor ... additionalDescriptors) {
        return this.and(Arrays.asList(additionalDescriptors));
    }

    public FormParametersSnippet and(List<ParameterDescriptor> additionalDescriptors) {
        ArrayList<ParameterDescriptor> combinedDescriptors = new ArrayList<ParameterDescriptor>(this.getParameterDescriptors().values());
        combinedDescriptors.addAll(additionalDescriptors);
        return new FormParametersSnippet(combinedDescriptors, this.getAttributes(), this.isIgnoreUndocumentedParameters());
    }
}

