/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.templates;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.restdocs.templates.TemplateFormat;
import org.springframework.restdocs.templates.TemplateResourceResolver;

public class StandardTemplateResourceResolver
implements TemplateResourceResolver {
    private final TemplateFormat templateFormat;

    public StandardTemplateResourceResolver(TemplateFormat templateFormat) {
        this.templateFormat = templateFormat;
    }

    @Override
    public Resource resolveTemplateResource(String name) {
        Resource formatSpecificCustomTemplate = this.getFormatSpecificCustomTemplate(name);
        if (formatSpecificCustomTemplate.exists()) {
            return formatSpecificCustomTemplate;
        }
        Resource customTemplate = this.getCustomTemplate(name);
        if (customTemplate.exists()) {
            return customTemplate;
        }
        Resource defaultTemplate = this.getDefaultTemplate(name);
        if (defaultTemplate.exists()) {
            return defaultTemplate;
        }
        throw new IllegalStateException("Template named '" + name + "' could not be resolved");
    }

    private Resource getFormatSpecificCustomTemplate(String name) {
        return new ClassPathResource(String.format("org/springframework/restdocs/templates/%s/%s.snippet", this.templateFormat.getId(), name));
    }

    private Resource getCustomTemplate(String name) {
        return new ClassPathResource(String.format("org/springframework/restdocs/templates/%s.snippet", name));
    }

    private Resource getDefaultTemplate(String name) {
        return new ClassPathResource(String.format("org/springframework/restdocs/templates/%s/default-%s.snippet", this.templateFormat.getId(), name));
    }
}

