/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.RestDocumentation;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.mockmvc.AbstractConfigurer;
import org.springframework.restdocs.mockmvc.SnippetConfigurer;
import org.springframework.restdocs.mockmvc.UriConfigurer;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolver;
import org.springframework.restdocs.snippet.StandardWriterResolver;
import org.springframework.restdocs.snippet.WriterResolver;
import org.springframework.restdocs.templates.StandardTemplateResourceResolver;
import org.springframework.restdocs.templates.TemplateEngine;
import org.springframework.restdocs.templates.TemplateResourceResolver;
import org.springframework.restdocs.templates.mustache.MustacheTemplateEngine;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurerAdapter;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.context.WebApplicationContext;

public class RestDocumentationMockMvcConfigurer
extends MockMvcConfigurerAdapter {
    private final UriConfigurer uriConfigurer = new UriConfigurer(this);
    private final SnippetConfigurer snippetConfigurer = new SnippetConfigurer(this);
    private final RequestPostProcessor requestPostProcessor;
    private final TemplateEngineConfigurer templateEngineConfigurer = new TemplateEngineConfigurer();
    private final WriterResolverConfigurer writerResolverConfigurer = new WriterResolverConfigurer();

    RestDocumentationMockMvcConfigurer(RestDocumentation restDocumentation) {
        this.requestPostProcessor = new ConfigurerApplyingRequestPostProcessor(restDocumentation, new AbstractConfigurer[]{this.uriConfigurer, this.writerResolverConfigurer, this.snippetConfigurer, this.templateEngineConfigurer});
    }

    public UriConfigurer uris() {
        return this.uriConfigurer;
    }

    public SnippetConfigurer snippets() {
        return this.snippetConfigurer;
    }

    public RestDocumentationMockMvcConfigurer templateEngine(TemplateEngine templateEngine) {
        this.templateEngineConfigurer.setTemplateEngine(templateEngine);
        return this;
    }

    public RestDocumentationMockMvcConfigurer writerResolver(WriterResolver writerResolver) {
        this.writerResolverConfigurer.setWriterResolver(writerResolver);
        return this;
    }

    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        return this.requestPostProcessor;
    }

    private static final class ConfigurerApplyingRequestPostProcessor
    implements RequestPostProcessor {
        private final RestDocumentation restDocumentation;
        private final AbstractConfigurer[] configurers;

        private ConfigurerApplyingRequestPostProcessor(RestDocumentation restDocumentation, AbstractConfigurer ... configurers) {
            this.restDocumentation = restDocumentation;
            this.configurers = configurers;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.setAttribute(RestDocumentationContext.class.getName(), (Object)this.restDocumentation.beforeOperation());
            for (AbstractConfigurer configurer : this.configurers) {
                configurer.apply(request);
            }
            return request;
        }
    }

    private static final class WriterResolverConfigurer
    extends AbstractConfigurer {
        private WriterResolver writerResolver;

        private WriterResolverConfigurer() {
        }

        @Override
        void apply(MockHttpServletRequest request) {
            WriterResolver resolverToUse = this.writerResolver;
            if (resolverToUse == null) {
                resolverToUse = new StandardWriterResolver((PropertyPlaceholderHelper.PlaceholderResolver)new RestDocumentationContextPlaceholderResolver((RestDocumentationContext)request.getAttribute(RestDocumentationContext.class.getName())));
            }
            request.setAttribute(WriterResolver.class.getName(), (Object)resolverToUse);
        }

        void setWriterResolver(WriterResolver writerResolver) {
            this.writerResolver = writerResolver;
        }
    }

    private static final class TemplateEngineConfigurer
    extends AbstractConfigurer {
        private TemplateEngine templateEngine = new MustacheTemplateEngine((TemplateResourceResolver)new StandardTemplateResourceResolver());

        private TemplateEngineConfigurer() {
        }

        @Override
        void apply(MockHttpServletRequest request) {
            request.setAttribute(TemplateEngine.class.getName(), (Object)this.templateEngine);
        }

        void setTemplateEngine(TemplateEngine templateEngine) {
            this.templateEngine = templateEngine;
        }
    }
}

