/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import java.util.Arrays;
import java.util.List;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.curl.CurlDocumentation;
import org.springframework.restdocs.http.HttpDocumentation;
import org.springframework.restdocs.mockmvc.AbstractNestedConfigurer;
import org.springframework.restdocs.mockmvc.RestDocumentationMockMvcConfigurer;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.snippet.WriterResolver;

public class SnippetConfigurer
extends AbstractNestedConfigurer<RestDocumentationMockMvcConfigurer> {
    private List<Snippet> defaultSnippets = Arrays.asList(CurlDocumentation.curlRequest(), HttpDocumentation.httpRequest(), HttpDocumentation.httpResponse());
    public static final String DEFAULT_SNIPPET_ENCODING = "UTF-8";
    private String snippetEncoding = "UTF-8";

    SnippetConfigurer(RestDocumentationMockMvcConfigurer parent) {
        super(parent);
    }

    public SnippetConfigurer withEncoding(String encoding) {
        this.snippetEncoding = encoding;
        return this;
    }

    @Override
    void apply(MockHttpServletRequest request) {
        ((WriterResolver)request.getAttribute(WriterResolver.class.getName())).setEncoding(this.snippetEncoding);
        request.setAttribute("org.springframework.restdocs.mockmvc.defaultSnippets", this.defaultSnippets);
    }

    public SnippetConfigurer withDefaults(Snippet ... defaultSnippets) {
        this.defaultSnippets = Arrays.asList(defaultSnippets);
        return this;
    }
}

