/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import java.util.HashMap;
import java.util.Map;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.generate.RestDocumentationGenerator;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.util.Assert;

public class RestDocumentationResultHandler
implements ResultHandler {
    static final String ATTRIBUTE_NAME_CONFIGURATION = "org.springframework.restdocs.configuration";
    private final RestDocumentationGenerator<MockHttpServletRequest, MockHttpServletResponse> delegate;

    RestDocumentationResultHandler(RestDocumentationGenerator<MockHttpServletRequest, MockHttpServletResponse> delegate) {
        Assert.notNull(delegate, (String)"delegate must be non-null");
        this.delegate = delegate;
    }

    public void handle(MvcResult result) throws Exception {
        this.delegate.handle((Object)result.getRequest(), (Object)result.getResponse(), this.retrieveConfiguration(result));
    }

    public RestDocumentationResultHandler document(Snippet ... snippets) {
        return new RestDocumentationResultHandler(this.delegate.withSnippets(snippets)){

            @Override
            public void handle(MvcResult result) {
                HashMap configuration = new HashMap(RestDocumentationResultHandler.this.retrieveConfiguration(result));
                configuration.remove("org.springframework.restdocs.defaultSnippets");
                this.getDelegate().handle((Object)result.getRequest(), (Object)result.getResponse(), configuration);
            }
        };
    }

    protected final RestDocumentationGenerator<MockHttpServletRequest, MockHttpServletResponse> getDelegate() {
        return this.delegate;
    }

    private Map<String, Object> retrieveConfiguration(MvcResult result) {
        Map configuration = (Map)result.getRequest().getAttribute(ATTRIBUTE_NAME_CONFIGURATION);
        Assert.state((configuration != null ? 1 : 0) != 0, () -> "REST Docs configuration not found. Did you forget to apply a " + MockMvcRestDocumentationConfigurer.class.getSimpleName() + " when building the MockMvc instance?");
        return configuration;
    }
}

