/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.oauth1.OAuth1Credentials;
import org.springframework.social.oauth1.SigningSupport;

class Spring30OAuth1RequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory delegate;
    private final OAuth1Credentials oauth1Credentials;

    public Spring30OAuth1RequestFactory(ClientHttpRequestFactory delegate, OAuth1Credentials oauth1Credentials) {
        this.delegate = delegate;
        this.oauth1Credentials = oauth1Credentials;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new OAuth1SigningRequest(this.delegate.createRequest(uri, httpMethod), this.oauth1Credentials);
    }

    private static class OAuth1SigningRequest
    implements ClientHttpRequest {
        private final ClientHttpRequest delegate;
        private ByteArrayOutputStream bodyOutputStream;
        private final SigningSupport signingUtils;
        private final OAuth1Credentials oauth1Credentials;

        public OAuth1SigningRequest(ClientHttpRequest delegate, OAuth1Credentials oauth1Credentials) {
            this.delegate = delegate;
            this.oauth1Credentials = oauth1Credentials;
            this.bodyOutputStream = new ByteArrayOutputStream();
            this.signingUtils = new SigningSupport();
        }

        public ClientHttpResponse execute() throws IOException {
            byte[] bufferedOutput = this.bodyOutputStream.toByteArray();
            String authorizationHeader = this.signingUtils.spring30buildAuthorizationHeaderValue(this, bufferedOutput, this.oauth1Credentials);
            this.delegate.getBody().write(bufferedOutput);
            this.delegate.getHeaders().set("Authorization", authorizationHeader);
            return this.delegate.execute();
        }

        public URI getURI() {
            return this.delegate.getURI();
        }

        public HttpMethod getMethod() {
            return this.delegate.getMethod();
        }

        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        public OutputStream getBody() throws IOException {
            return this.bodyOutputStream;
        }
    }
}

