/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.social.oauth2.OAuth2RequestInterceptor;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.oauth2.Spring30OAuth2RequestFactory;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;

class ProtectedResourceClientFactory {
    private static boolean interceptorsSupported = ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestInterceptor", (ClassLoader)ProtectedResourceClientFactory.class.getClassLoader());
    private static boolean listBasedInterceptors = false;
    private static Method setInterceptorsMethod;

    ProtectedResourceClientFactory() {
    }

    public static RestTemplate create(String accessToken, OAuth2Version version) {
        RestTemplate client;
        block5: {
            client = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
            if (interceptorsSupported) {
                OAuth2RequestInterceptor interceptor = new OAuth2RequestInterceptor(accessToken, version);
                try {
                    if (listBasedInterceptors) {
                        LinkedList<OAuth2RequestInterceptor> interceptors = new LinkedList<OAuth2RequestInterceptor>();
                        interceptors.add(interceptor);
                        setInterceptorsMethod.invoke((Object)client, interceptors);
                        break block5;
                    }
                    setInterceptorsMethod.invoke((Object)client, new Object[]{new ClientHttpRequestInterceptor[]{interceptor}});
                }
                catch (Exception shouldntHappen) {}
            } else {
                client.setRequestFactory((ClientHttpRequestFactory)new Spring30OAuth2RequestFactory(client.getRequestFactory(), accessToken, version));
            }
        }
        return client;
    }

    public static ClientHttpRequestFactory addOAuthSigning(ClientHttpRequestFactory requestFactory, String accessToken, OAuth2Version version) {
        if (interceptorsSupported) {
            return requestFactory;
        }
        return new Spring30OAuth2RequestFactory(requestFactory, accessToken, version);
    }

    static {
        if (interceptorsSupported) {
            try {
                setInterceptorsMethod = RestTemplate.class.getMethod("setInterceptors", List.class);
                listBasedInterceptors = true;
            }
            catch (NoSuchMethodException e) {
                try {
                    setInterceptorsMethod = RestTemplate.class.getMethod("setInterceptors", new ClientHttpRequestInterceptor[0].getClass());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }
}

