/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.oauth2.OAuth2Version;

class Spring30OAuth2RequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory delegate;
    private final String accessToken;
    private final OAuth2Version oauth2Version;

    public Spring30OAuth2RequestFactory(ClientHttpRequestFactory delegate, String accessToken, OAuth2Version oauth2Version) {
        this.delegate = delegate;
        this.accessToken = accessToken;
        this.oauth2Version = oauth2Version;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new OAuth2SigningRequest(this.delegate.createRequest(uri, httpMethod), this.accessToken, this.oauth2Version);
    }

    private static class OAuth2SigningRequest
    implements ClientHttpRequest {
        private final ClientHttpRequest delegate;
        private ByteArrayOutputStream bodyOutputStream;
        private final String accessToken;
        private final OAuth2Version oauth2Version;

        public OAuth2SigningRequest(ClientHttpRequest delegate, String accessToken, OAuth2Version oauth2Version) {
            this.delegate = delegate;
            this.accessToken = accessToken;
            this.oauth2Version = oauth2Version;
            this.bodyOutputStream = new ByteArrayOutputStream();
        }

        public ClientHttpResponse execute() throws IOException {
            byte[] bufferedOutput = this.bodyOutputStream.toByteArray();
            this.delegate.getBody().write(bufferedOutput);
            this.delegate.getHeaders().set("Authorization", this.oauth2Version.getAuthorizationHeaderValue(this.accessToken));
            return this.delegate.execute();
        }

        public URI getURI() {
            return this.delegate.getURI();
        }

        public HttpMethod getMethod() {
            return this.delegate.getMethod();
        }

        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        public OutputStream getBody() throws IOException {
            return this.bodyOutputStream;
        }
    }
}

