/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.social.support.BufferingClientHttpRequestFactory;
import org.springframework.social.support.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.ClassUtils;

public class ClientHttpRequestFactorySelector {
    private static boolean HTTP_COMPONENTS_AVAILABLE = ClassUtils.isPresent((String)"org.apache.http.client.HttpClient", (ClassLoader)ClientHttpRequestFactory.class.getClassLoader());

    public static ClientHttpRequestFactory getRequestFactory() {
        int proxyPort;
        Properties properties = System.getProperties();
        String proxyHost = properties.getProperty("http.proxyHost");
        int n = proxyPort = properties.containsKey("http.proxyPort") ? Integer.valueOf(properties.getProperty("http.proxyPort")) : 80;
        if (HTTP_COMPONENTS_AVAILABLE) {
            return HttpComponentsClientRequestFactoryCreator.createRequestFactory(proxyHost, proxyPort);
        }
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (proxyHost != null) {
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        return requestFactory;
    }

    public static ClientHttpRequestFactory bufferRequests(ClientHttpRequestFactory requestFactory) {
        return new BufferingClientHttpRequestFactory(requestFactory);
    }

    private static class HttpComponentsClientRequestFactoryCreator {
        private HttpComponentsClientRequestFactoryCreator() {
        }

        public static ClientHttpRequestFactory createRequestFactory(String proxyHost, int proxyPort) {
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(){

                protected void postProcessHttpRequest(HttpUriRequest request) {
                    HttpProtocolParams.setUseExpectContinue((HttpParams)request.getParams(), (boolean)false);
                }
            };
            if (proxyHost != null) {
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                requestFactory.setHttpClient((HttpClient)httpClient);
            }
            return requestFactory;
        }
    }
}

