/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.DuplicateConnectionException;
import org.springframework.social.connect.NoSuchConnectionException;
import org.springframework.social.connect.NotConnectedException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JdbcConnectionRepository
implements ConnectionRepository {
    private final String userId;
    private final JdbcTemplate jdbcTemplate;
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final TextEncryptor textEncryptor;
    private final String tablePrefix;
    private final ServiceProviderConnectionMapper connectionMapper = new ServiceProviderConnectionMapper();

    public JdbcConnectionRepository(String userId, JdbcTemplate jdbcTemplate, ConnectionFactoryLocator connectionFactoryLocator, TextEncryptor textEncryptor, String tablePrefix) {
        this.userId = userId;
        this.jdbcTemplate = jdbcTemplate;
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.textEncryptor = textEncryptor;
        this.tablePrefix = tablePrefix;
    }

    @Override
    public MultiValueMap<String, Connection<?>> findAllConnections() {
        List resultList = this.jdbcTemplate.query(this.selectFromUserConnection() + " where userId = ? order by providerId, rank", (RowMapper)this.connectionMapper, new Object[]{this.userId});
        LinkedMultiValueMap connections = new LinkedMultiValueMap();
        Set<String> registeredProviderIds = this.connectionFactoryLocator.registeredProviderIds();
        for (String registeredProviderId : registeredProviderIds) {
            connections.put((Object)registeredProviderId, Collections.emptyList());
        }
        for (Connection connection : resultList) {
            String providerId = connection.getKey().getProviderId();
            if (((List)connections.get((Object)providerId)).size() == 0) {
                connections.put((Object)providerId, new LinkedList());
            }
            connections.add((Object)providerId, (Object)connection);
        }
        return connections;
    }

    @Override
    public List<Connection<?>> findConnections(String providerId) {
        return this.jdbcTemplate.query(this.selectFromUserConnection() + " where userId = ? and providerId = ? order by rank", (RowMapper)this.connectionMapper, new Object[]{this.userId, providerId});
    }

    @Override
    public <A> List<Connection<A>> findConnections(Class<A> apiType) {
        List<Connection<A>> connections = this.findConnections(this.getProviderId(apiType));
        return connections;
    }

    @Override
    public MultiValueMap<String, Connection<?>> findConnectionsToUsers(MultiValueMap<String, String> providerUsers) {
        if (providerUsers == null || providerUsers.isEmpty()) {
            throw new IllegalArgumentException("Unable to execute find: no providerUsers provided");
        }
        StringBuilder providerUsersCriteriaSql = new StringBuilder();
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userId", (Object)this.userId);
        Iterator it = providerUsers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String providerId = (String)entry.getKey();
            providerUsersCriteriaSql.append("providerId = :providerId_").append(providerId).append(" and providerUserId in (:providerUserIds_").append(providerId).append(")");
            parameters.addValue("providerId_" + providerId, (Object)providerId);
            parameters.addValue("providerUserIds_" + providerId, entry.getValue());
            if (!it.hasNext()) continue;
            providerUsersCriteriaSql.append(" or ");
        }
        List resultList = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate).query(this.selectFromUserConnection() + " where userId = :userId and " + providerUsersCriteriaSql + " order by providerId, rank", (SqlParameterSource)parameters, (RowMapper)this.connectionMapper);
        LinkedMultiValueMap connectionsForUsers = new LinkedMultiValueMap();
        for (Connection connection : resultList) {
            String providerId = connection.getKey().getProviderId();
            List userIds = (List)providerUsers.get((Object)providerId);
            ArrayList<Connection> connections = (ArrayList<Connection>)connectionsForUsers.get((Object)providerId);
            if (connections == null) {
                connections = new ArrayList<Connection>(userIds.size());
                for (int i = 0; i < userIds.size(); ++i) {
                    connections.add(null);
                }
                connectionsForUsers.put((Object)providerId, connections);
            }
            String providerUserId = connection.getKey().getProviderUserId();
            int connectionIndex = userIds.indexOf(providerUserId);
            connections.set(connectionIndex, connection);
        }
        return connectionsForUsers;
    }

    @Override
    public Connection<?> getConnection(ConnectionKey connectionKey) {
        try {
            return (Connection)this.jdbcTemplate.queryForObject(this.selectFromUserConnection() + " where userId = ? and providerId = ? and providerUserId = ?", (RowMapper)this.connectionMapper, new Object[]{this.userId, connectionKey.getProviderId(), connectionKey.getProviderUserId()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchConnectionException(connectionKey);
        }
    }

    @Override
    public <A> Connection<A> getConnection(Class<A> apiType, String providerUserId) {
        String providerId = this.getProviderId(apiType);
        return this.getConnection(new ConnectionKey(providerId, providerUserId));
    }

    @Override
    public <A> Connection<A> getPrimaryConnection(Class<A> apiType) {
        String providerId = this.getProviderId(apiType);
        Connection<?> connection = this.findPrimaryConnection(providerId);
        if (connection == null) {
            throw new NotConnectedException(providerId);
        }
        return connection;
    }

    @Override
    public <A> Connection<A> findPrimaryConnection(Class<A> apiType) {
        String providerId = this.getProviderId(apiType);
        return this.findPrimaryConnection(providerId);
    }

    @Override
    @Transactional
    public void addConnection(Connection<?> connection) {
        try {
            ConnectionData data = connection.createData();
            int rank = this.jdbcTemplate.queryForInt("select coalesce(max(rank) + 1, 1) as rank from " + this.tablePrefix + "UserConnection where userId = ? and providerId = ?", new Object[]{this.userId, data.getProviderId()});
            this.jdbcTemplate.update("insert into " + this.tablePrefix + "UserConnection (userId, providerId, providerUserId, rank, displayName, profileUrl, imageUrl, accessToken, secret, refreshToken, expireTime) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{this.userId, data.getProviderId(), data.getProviderUserId(), rank, data.getDisplayName(), data.getProfileUrl(), data.getImageUrl(), this.encrypt(data.getAccessToken()), this.encrypt(data.getSecret()), this.encrypt(data.getRefreshToken()), data.getExpireTime()});
        }
        catch (DuplicateKeyException e) {
            throw new DuplicateConnectionException(connection.getKey());
        }
    }

    @Override
    public void updateConnection(Connection<?> connection) {
        ConnectionData data = connection.createData();
        this.jdbcTemplate.update("update " + this.tablePrefix + "UserConnection set displayName = ?, profileUrl = ?, imageUrl = ?, accessToken = ?, secret = ?, refreshToken = ?, expireTime = ? where userId = ? and providerId = ? and providerUserId = ?", new Object[]{data.getDisplayName(), data.getProfileUrl(), data.getImageUrl(), this.encrypt(data.getAccessToken()), this.encrypt(data.getSecret()), this.encrypt(data.getRefreshToken()), data.getExpireTime(), this.userId, data.getProviderId(), data.getProviderUserId()});
    }

    @Override
    public void removeConnections(String providerId) {
        this.jdbcTemplate.update("delete from " + this.tablePrefix + "UserConnection where userId = ? and providerId = ?", new Object[]{this.userId, providerId});
    }

    @Override
    public void removeConnection(ConnectionKey connectionKey) {
        this.jdbcTemplate.update("delete from " + this.tablePrefix + "UserConnection where userId = ? and providerId = ? and providerUserId = ?", new Object[]{this.userId, connectionKey.getProviderId(), connectionKey.getProviderUserId()});
    }

    private String selectFromUserConnection() {
        return "select userId, providerId, providerUserId, displayName, profileUrl, imageUrl, accessToken, secret, refreshToken, expireTime from " + this.tablePrefix + "UserConnection";
    }

    private Connection<?> findPrimaryConnection(String providerId) {
        List connections = this.jdbcTemplate.query(this.selectFromUserConnection() + " where userId = ? and providerId = ? and rank = 1", (RowMapper)this.connectionMapper, new Object[]{this.userId, providerId});
        if (connections.size() > 0) {
            return (Connection)connections.get(0);
        }
        return null;
    }

    private <A> String getProviderId(Class<A> apiType) {
        return this.connectionFactoryLocator.getConnectionFactory(apiType).getProviderId();
    }

    private String encrypt(String text) {
        return text != null ? this.textEncryptor.encrypt(text) : text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ServiceProviderConnectionMapper
    implements RowMapper<Connection<?>> {
        private ServiceProviderConnectionMapper() {
        }

        public Connection<?> mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConnectionData connectionData = this.mapConnectionData(rs);
            ConnectionFactory<?> connectionFactory = JdbcConnectionRepository.this.connectionFactoryLocator.getConnectionFactory(connectionData.getProviderId());
            return connectionFactory.createConnection(connectionData);
        }

        private ConnectionData mapConnectionData(ResultSet rs) throws SQLException {
            return new ConnectionData(rs.getString("providerId"), rs.getString("providerUserId"), rs.getString("displayName"), rs.getString("profileUrl"), rs.getString("imageUrl"), this.decrypt(rs.getString("accessToken")), this.decrypt(rs.getString("secret")), this.decrypt(rs.getString("refreshToken")), this.expireTime(rs.getLong("expireTime")));
        }

        private String decrypt(String encryptedText) {
            return encryptedText != null ? JdbcConnectionRepository.this.textEncryptor.decrypt(encryptedText) : encryptedText;
        }

        private Long expireTime(long expireTime) {
            return expireTime == 0L ? null : Long.valueOf(expireTime);
        }
    }
}

