/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnection<A>
implements Connection<A> {
    private final ApiAdapter<A> apiAdapter;
    private ConnectionKey key;
    private String displayName;
    private String profileUrl;
    private String imageUrl;
    private boolean valuesInitialized;
    private final Object monitor = new Object();

    public AbstractConnection(ApiAdapter<A> apiAdapter) {
        this.apiAdapter = apiAdapter;
    }

    public AbstractConnection(ConnectionData data, ApiAdapter<A> apiAdapter) {
        this.key = new ConnectionKey(data.getProviderId(), data.getProviderUserId());
        this.apiAdapter = apiAdapter;
        this.displayName = data.getDisplayName();
        this.profileUrl = data.getProfileUrl();
        this.imageUrl = data.getImageUrl();
        this.valuesInitialized = true;
    }

    @Override
    public ConnectionKey getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        Object object = this.monitor;
        synchronized (object) {
            this.initValues();
            return this.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProfileUrl() {
        Object object = this.monitor;
        synchronized (object) {
            this.initValues();
            return this.profileUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getImageUrl() {
        Object object = this.monitor;
        synchronized (object) {
            this.initValues();
            return this.imageUrl;
        }
    }

    @Override
    public boolean test() {
        return this.apiAdapter.test(this.getApi());
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void refresh() {
    }

    @Override
    public UserProfile fetchUserProfile() {
        return this.apiAdapter.fetchUserProfile(this.getApi());
    }

    @Override
    public void updateStatus(String message) {
        this.apiAdapter.updateStatus(this.getApi(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        Object object = this.monitor;
        synchronized (object) {
            this.setValues();
        }
    }

    @Override
    public abstract A getApi();

    @Override
    public abstract ConnectionData createData();

    protected void initKey(String providerId, String providerUserId) {
        if (providerUserId == null) {
            providerUserId = this.setValues().providerUserId;
        }
        this.key = new ConnectionKey(providerId, providerUserId);
    }

    protected Object getMonitor() {
        return this.monitor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        return this.key.equals(other.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    private void initValues() {
        if (!this.valuesInitialized) {
            this.setValues();
        }
    }

    private ServiceProviderConnectionValuesImpl setValues() {
        ServiceProviderConnectionValuesImpl values = new ServiceProviderConnectionValuesImpl();
        this.apiAdapter.setConnectionValues(this.getApi(), values);
        this.valuesInitialized = true;
        return values;
    }

    private class ServiceProviderConnectionValuesImpl
    implements ConnectionValues {
        private String providerUserId;

        private ServiceProviderConnectionValuesImpl() {
        }

        public void setProviderUserId(String providerUserId) {
            this.providerUserId = providerUserId;
        }

        public void setDisplayName(String displayName) {
            AbstractConnection.this.displayName = displayName;
        }

        public void setProfileUrl(String profileUrl) {
            AbstractConnection.this.profileUrl = profileUrl;
        }

        public void setImageUrl(String imageUrl) {
            AbstractConnection.this.imageUrl = imageUrl;
        }
    }
}

