/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.social.oauth1.EmptyMultiValueMap;
import org.springframework.social.oauth1.OAuth1Credentials;
import org.springframework.social.oauth1.TreeMultiValueMap;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SigningSupport {
    private TimestampGenerator timestampGenerator = new DefaultTimestampGenerator();
    private static final BitSet UNRESERVED;
    private static final String HMAC_SHA1_SIGNATURE_NAME = "HMAC-SHA1";
    private static final String HMAC_SHA1_MAC_NAME = "HmacSHA1";
    private static final String UTF8_CHARSET_NAME = "UTF-8";

    SigningSupport() {
    }

    public String buildAuthorizationHeaderValue(HttpMethod method, URI targetUrl, Map<String, String> oauthParameters, MultiValueMap<String, String> additionalParameters, String consumerSecret, String tokenSecret) {
        StringBuilder header = new StringBuilder();
        header.append("OAuth ");
        for (Map.Entry<String, String> entry : oauthParameters.entrySet()) {
            header.append(SigningSupport.oauthEncode(entry.getKey())).append("=\"").append(SigningSupport.oauthEncode(entry.getValue())).append("\", ");
        }
        LinkedMultiValueMap collectedParameters = new LinkedMultiValueMap((int)((double)(oauthParameters.size() + additionalParameters.size()) / 0.75 + 1.0));
        collectedParameters.setAll(oauthParameters);
        collectedParameters.putAll(additionalParameters);
        String baseString = this.buildBaseString(method, this.getBaseStringUri(targetUrl), (MultiValueMap<String, String>)collectedParameters);
        String signature = this.calculateSignature(baseString, consumerSecret, tokenSecret);
        header.append(SigningSupport.oauthEncode("oauth_signature")).append("=\"").append(SigningSupport.oauthEncode(signature)).append("\"");
        return header.toString();
    }

    public String buildAuthorizationHeaderValue(HttpRequest request, byte[] body, OAuth1Credentials oauth1Credentials) {
        Map<String, String> oauthParameters = this.commonOAuthParameters(oauth1Credentials.getConsumerKey());
        oauthParameters.put("oauth_token", oauth1Credentials.getAccessToken());
        MultiValueMap<String, String> additionalParameters = this.union(this.readFormParameters(request.getHeaders().getContentType(), body), this.parseFormParameters(request.getURI().getRawQuery()));
        return this.buildAuthorizationHeaderValue(request.getMethod(), request.getURI(), oauthParameters, additionalParameters, oauth1Credentials.getConsumerSecret(), oauth1Credentials.getAccessTokenSecret());
    }

    public String spring30buildAuthorizationHeaderValue(ClientHttpRequest request, byte[] body, OAuth1Credentials oauth1Credentials) {
        Map<String, String> oauthParameters = this.commonOAuthParameters(oauth1Credentials.getConsumerKey());
        oauthParameters.put("oauth_token", oauth1Credentials.getAccessToken());
        MultiValueMap<String, String> additionalParameters = this.union(this.readFormParameters(request.getHeaders().getContentType(), body), this.parseFormParameters(request.getURI().getRawQuery()));
        return this.buildAuthorizationHeaderValue(request.getMethod(), request.getURI(), oauthParameters, additionalParameters, oauth1Credentials.getConsumerSecret(), oauth1Credentials.getAccessTokenSecret());
    }

    Map<String, String> commonOAuthParameters(String consumerKey) {
        HashMap<String, String> oauthParameters = new HashMap<String, String>();
        oauthParameters.put("oauth_consumer_key", consumerKey);
        oauthParameters.put("oauth_signature_method", HMAC_SHA1_SIGNATURE_NAME);
        long timestamp = this.timestampGenerator.generateTimestamp();
        oauthParameters.put("oauth_timestamp", Long.toString(timestamp));
        oauthParameters.put("oauth_nonce", Long.toString(this.timestampGenerator.generateNonce(timestamp)));
        oauthParameters.put("oauth_version", "1.0");
        return oauthParameters;
    }

    String buildBaseString(HttpMethod method, String targetUrl, MultiValueMap<String, String> collectedParameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.name()).append('&').append(SigningSupport.oauthEncode(targetUrl)).append('&');
        builder.append(SigningSupport.oauthEncode(this.normalizeParameters(collectedParameters)));
        return builder.toString();
    }

    void setTimestampGenerator(TimestampGenerator timestampGenerator) {
        this.timestampGenerator = timestampGenerator;
    }

    private String normalizeParameters(MultiValueMap<String, String> collectedParameters) {
        TreeMultiValueMap sortedEncodedParameters = new TreeMultiValueMap();
        for (Map.Entry entry : collectedParameters.entrySet()) {
            String collectedName = (String)entry.getKey();
            List collectedValues = (List)entry.getValue();
            ArrayList<String> encodedValues = new ArrayList<String>(collectedValues.size());
            sortedEncodedParameters.put(SigningSupport.oauthEncode(collectedName), encodedValues);
            for (String value : collectedValues) {
                encodedValues.add(value != null ? SigningSupport.oauthEncode(value) : "");
            }
            Collections.sort(encodedValues);
        }
        StringBuilder paramsBuilder = new StringBuilder();
        Iterator entryIt = sortedEncodedParameters.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIt.next();
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            Iterator valueIt = values.iterator();
            while (valueIt.hasNext()) {
                String value;
                value = (String)valueIt.next();
                paramsBuilder.append(name).append('=').append(value);
                if (!valueIt.hasNext()) continue;
                paramsBuilder.append("&");
            }
            if (!entryIt.hasNext()) continue;
            paramsBuilder.append("&");
        }
        return paramsBuilder.toString();
    }

    private String calculateSignature(String baseString, String consumerSecret, String tokenSecret) {
        String key = SigningSupport.oauthEncode(consumerSecret) + "&" + (tokenSecret != null ? SigningSupport.oauthEncode(tokenSecret) : "");
        return this.sign(baseString, key);
    }

    private String sign(String signatureBaseString, String key) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1_MAC_NAME);
            SecretKeySpec spec = new SecretKeySpec(key.getBytes(), HMAC_SHA1_MAC_NAME);
            mac.init(spec);
            byte[] text = signatureBaseString.getBytes(UTF8_CHARSET_NAME);
            byte[] signatureBytes = mac.doFinal(text);
            signatureBytes = Base64.encode((byte[])signatureBytes);
            String signature = new String(signatureBytes, UTF8_CHARSET_NAME);
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException shouldntHappen) {
            throw new IllegalStateException(shouldntHappen);
        }
    }

    private MultiValueMap<String, String> readFormParameters(MediaType bodyType, byte[] bodyBytes) {
        if (bodyType != null && bodyType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED)) {
            String body;
            try {
                body = new String(bodyBytes, UTF8_CHARSET_NAME);
            }
            catch (UnsupportedEncodingException shouldntHappen) {
                throw new IllegalStateException(shouldntHappen);
            }
            return this.parseFormParameters(body);
        }
        return EmptyMultiValueMap.instance();
    }

    private MultiValueMap<String, String> parseFormParameters(String parameterString) {
        if (parameterString == null || parameterString.length() == 0) {
            return EmptyMultiValueMap.instance();
        }
        String[] pairs = StringUtils.tokenizeToStringArray((String)parameterString, (String)"&");
        LinkedMultiValueMap result = new LinkedMultiValueMap(pairs.length);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.add((Object)SigningSupport.formDecode(pair), (Object)"");
                continue;
            }
            String name = SigningSupport.formDecode(pair.substring(0, idx));
            String value = SigningSupport.formDecode(pair.substring(idx + 1));
            result.add((Object)name, (Object)value);
        }
        return result;
    }

    private String getBaseStringUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), this.getPort(uri), uri.getPath(), null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private MultiValueMap<String, String> union(MultiValueMap<String, String> map1, MultiValueMap<String, String> map2) {
        LinkedMultiValueMap union = new LinkedMultiValueMap(map1);
        Set map2Entries = map2.entrySet();
        for (Map.Entry entry : map2Entries) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                union.add((Object)key, (Object)value);
            }
        }
        return union;
    }

    private int getPort(URI uri) {
        if (uri.getScheme().equals("http") && uri.getPort() == 80 || uri.getScheme().equals("https") && uri.getPort() == 443) {
            return -1;
        }
        return uri.getPort();
    }

    private static String oauthEncode(String param) {
        try {
            byte[] bytes = SigningSupport.encode(param.getBytes(UTF8_CHARSET_NAME), UNRESERVED);
            return new String(bytes, "US-ASCII");
        }
        catch (Exception shouldntHappen) {
            throw new IllegalStateException(shouldntHappen);
        }
    }

    private static byte[] encode(byte[] source, BitSet notEncoded) {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length * 2);
        for (int i = 0; i < source.length; ++i) {
            int b = source[i];
            if (b < 0) {
                b += 256;
            }
            if (notEncoded.get(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
        }
        return bos.toByteArray();
    }

    private static String formDecode(String encoded) {
        try {
            return URLDecoder.decode(encoded, UTF8_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException shouldntHappen) {
            throw new IllegalStateException(shouldntHappen);
        }
    }

    static {
        int i;
        BitSet alpha = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            alpha.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            alpha.set(i);
        }
        BitSet digit = new BitSet(256);
        for (int i2 = 48; i2 <= 57; ++i2) {
            digit.set(i2);
        }
        BitSet unreserved = new BitSet(256);
        unreserved.or(alpha);
        unreserved.or(digit);
        unreserved.set(45);
        unreserved.set(46);
        unreserved.set(95);
        unreserved.set(126);
        UNRESERVED = unreserved;
    }

    private static class DefaultTimestampGenerator
    implements TimestampGenerator {
        static final Random RANDOM = new Random();

        private DefaultTimestampGenerator() {
        }

        public long generateTimestamp() {
            return System.currentTimeMillis() / 1000L;
        }

        public long generateNonce(long timestamp) {
            return timestamp + (long)RANDOM.nextInt();
        }
    }

    static interface TimestampGenerator {
        public long generateTimestamp();

        public long generateNonce(long var1);
    }
}

