/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.social.ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.oauth2.ProtectedResourceClientFactory;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuth2ApiBinding
implements ApiBinding {
    private final String accessToken;
    private final RestTemplate restTemplate;

    protected AbstractOAuth2ApiBinding() {
        this.accessToken = null;
        this.restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        this.restTemplate.setMessageConverters(this.getMessageConverters());
        this.configureRestTemplate(this.restTemplate);
    }

    protected AbstractOAuth2ApiBinding(String accessToken) {
        this.accessToken = accessToken;
        this.restTemplate = ProtectedResourceClientFactory.create(accessToken, this.getOAuth2Version());
        this.restTemplate.setMessageConverters(this.getMessageConverters());
        this.configureRestTemplate(this.restTemplate);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        if (this.isAuthorized()) {
            this.restTemplate.setRequestFactory(ProtectedResourceClientFactory.addOAuthSigning(requestFactory, this.accessToken, this.getOAuth2Version()));
        } else {
            this.restTemplate.setRequestFactory(requestFactory);
        }
    }

    @Override
    public boolean isAuthorized() {
        return this.accessToken != null;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.BEARER;
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getFormMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getJsonMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getByteArrayMessageConverter());
        return messageConverters;
    }

    protected FormHttpMessageConverter getFormMessageConverter() {
        FormHttpMessageConverter converter = new FormHttpMessageConverter();
        converter.setCharset(Charset.forName("UTF-8"));
        return converter;
    }

    protected MappingJacksonHttpMessageConverter getJsonMessageConverter() {
        return new MappingJacksonHttpMessageConverter();
    }

    protected ByteArrayHttpMessageConverter getByteArrayMessageConverter() {
        ByteArrayHttpMessageConverter converter = new ByteArrayHttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.IMAGE_JPEG, MediaType.IMAGE_GIF, MediaType.IMAGE_PNG));
        return converter;
    }
}

