/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.social.oauth1.OAuth1Credentials;
import org.springframework.social.oauth1.OAuth1RequestInterceptor;
import org.springframework.social.oauth1.Spring30OAuth1RequestFactory;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;

class ProtectedResourceClientFactory {
    private static boolean interceptorsSupported = ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestInterceptor", (ClassLoader)ProtectedResourceClientFactory.class.getClassLoader());
    private static boolean listBasedInterceptors = false;
    private static Method setInterceptorsMethod;

    ProtectedResourceClientFactory() {
    }

    public static RestTemplate create(OAuth1Credentials credentials) {
        RestTemplate client;
        block5: {
            client = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
            if (interceptorsSupported) {
                OAuth1RequestInterceptor interceptor = new OAuth1RequestInterceptor(credentials);
                try {
                    if (listBasedInterceptors) {
                        LinkedList<OAuth1RequestInterceptor> interceptors = new LinkedList<OAuth1RequestInterceptor>();
                        interceptors.add(interceptor);
                        setInterceptorsMethod.invoke((Object)client, interceptors);
                        break block5;
                    }
                    setInterceptorsMethod.invoke((Object)client, new Object[]{new ClientHttpRequestInterceptor[]{interceptor}});
                }
                catch (Exception exception) {}
            } else {
                client.setRequestFactory((ClientHttpRequestFactory)new Spring30OAuth1RequestFactory(client.getRequestFactory(), credentials));
            }
        }
        return client;
    }

    public static ClientHttpRequestFactory addOAuthSigning(ClientHttpRequestFactory requestFactory, OAuth1Credentials credentials) {
        if (interceptorsSupported) {
            return requestFactory;
        }
        return new Spring30OAuth1RequestFactory(requestFactory, credentials);
    }

    static {
        if (interceptorsSupported) {
            try {
                setInterceptorsMethod = RestTemplate.class.getMethod("setInterceptors", List.class);
                listBasedInterceptors = true;
            }
            catch (NoSuchMethodException e) {
                try {
                    setInterceptorsMethod = RestTemplate.class.getMethod("setInterceptors", new ClientHttpRequestInterceptor[0].getClass());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }
}

