/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.social.support.HttpComponentsClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private static final boolean VERSION_4_1_AVAILABLE = ClassUtils.hasConstructor(ThreadSafeClientConnManager.class, (Class[])new Class[]{SchemeRegistry.class});
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 100;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 5;
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private HttpClient httpClient;

    public HttpComponentsClientHttpRequestFactory() {
        this.httpClient = VERSION_4_1_AVAILABLE ? HttpComponentsClient_4_1.getInstance() : HttpComponentsClient_4_0.getInstance();
        this.setReadTimeout(60000);
    }

    public HttpComponentsClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        this.httpClient = httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.getHttpClient().getParams().setIntParameter("http.socket.timeout", timeout);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        return new HttpComponentsClientHttpRequest(this.getHttpClient(), httpRequest);
    }

    protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case HEAD: {
                return new HttpHead(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case TRACE: {
                return new HttpTrace(uri);
            }
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + httpMethod);
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
    }

    public void destroy() {
        this.getHttpClient().getConnectionManager().shutdown();
    }

    private static class HttpComponentsClient_4_0 {
        private HttpComponentsClient_4_0() {
        }

        public static HttpClient getInstance() {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
            BasicHttpParams params = new BasicHttpParams();
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)100);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(5));
            return new DefaultHttpClient((ClientConnectionManager)connectionManager, null);
        }
    }

    private static class HttpComponentsClient_4_1 {
        private HttpComponentsClient_4_1() {
        }

        public static HttpClient getInstance() {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeRegistry);
            connectionManager.setMaxTotal(100);
            connectionManager.setDefaultMaxPerRoute(5);
            return new DefaultHttpClient((ClientConnectionManager)connectionManager);
        }
    }
}

