/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ClassUtils;

final class HttpComponentsClientHttpResponse
implements ClientHttpResponse {
    private static final boolean VERSION_4_1_AVAILABLE = ClassUtils.hasMethod(EntityUtils.class, (String)"consume", (Class[])new Class[]{HttpEntity.class});
    private final HttpResponse httpResponse;
    private HttpHeaders headers;

    public HttpComponentsClientHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public int getRawStatusCode() throws IOException {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public HttpStatus getStatusCode() throws IOException {
        return HttpStatus.valueOf((int)this.httpResponse.getStatusLine().getStatusCode());
    }

    public String getStatusText() throws IOException {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            for (Header header : this.httpResponse.getAllHeaders()) {
                this.headers.add(header.getName(), header.getValue());
            }
        }
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        return entity != null ? entity.getContent() : null;
    }

    public void close() {
        HttpEntity entity = this.httpResponse.getEntity();
        if (VERSION_4_1_AVAILABLE) {
            HttpComponentsClient_4_1.close(entity);
        } else {
            HttpComponentsClient_4_0.close(entity);
        }
    }

    private static class HttpComponentsClient_4_0 {
        private HttpComponentsClient_4_0() {
        }

        public static void close(HttpEntity entity) {
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static class HttpComponentsClient_4_1 {
        private HttpComponentsClient_4_1() {
        }

        public static void close(HttpEntity entity) {
            if (entity != null) {
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

