/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.social;

/**
 * Indicates that an otherwise uncategorized error occurred while consuming a provider API.
 * @author Craig Walls
 */
@SuppressWarnings("serial")
public class UncategorizedApiException extends ApiException {

	public UncategorizedApiException(String providerId, String message, Throwable cause) {
		super(providerId, message, cause);
	}
	
}
