/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.ClassUtils;

public class ClientHttpRequestFactorySelector {
    private static final boolean HTTP_COMPONENTS_AVAILABLE = ClassUtils.isPresent((String)"org.apache.http.client.HttpClient", (ClassLoader)ClientHttpRequestFactory.class.getClassLoader());

    public static ClientHttpRequestFactory foo() {
        return new HttpComponentsClientHttpRequestFactory();
    }

    public static ClientHttpRequestFactory getRequestFactory() {
        int proxyPort;
        Properties properties = System.getProperties();
        String proxyHost = properties.getProperty("http.proxyHost");
        int n = proxyPort = properties.containsKey("http.proxyPort") ? Integer.valueOf(properties.getProperty("http.proxyPort")) : 80;
        if (HTTP_COMPONENTS_AVAILABLE) {
            return HttpComponentsClientRequestFactoryCreator.createRequestFactory(proxyHost, proxyPort);
        }
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (proxyHost != null) {
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        return requestFactory;
    }

    public static ClientHttpRequestFactory bufferRequests(ClientHttpRequestFactory requestFactory) {
        return new BufferingClientHttpRequestFactory(requestFactory);
    }

    public static void setAllTrust(boolean isAllTrust) {
        HttpComponentsClientRequestFactoryCreator.isAllTrust = isAllTrust;
    }

    public static class HttpComponentsClientRequestFactoryCreator {
        private static boolean isAllTrust = false;

        public static ClientHttpRequestFactory createRequestFactory(String proxyHost, int proxyPort) {
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(){

                protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                    HttpClientContext context = new HttpClientContext();
                    context.setAttribute("http.protocol.expect-continue", (Object)false);
                    return context;
                }
            };
            if (proxyHost != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                CloseableHttpClient httpClient = isAllTrust ? HttpComponentsClientRequestFactoryCreator.getAllTrustClient(proxy) : HttpComponentsClientRequestFactoryCreator.getClient(proxy);
                requestFactory.setHttpClient((HttpClient)httpClient);
            }
            return requestFactory;
        }

        private static CloseableHttpClient getClient(HttpHost proxy) {
            return HttpClients.custom().setProxy(proxy).build();
        }

        private static CloseableHttpClient getAllTrustClient(HttpHost proxy) {
            return HttpClients.custom().setProxy(proxy).setSslcontext(HttpComponentsClientRequestFactoryCreator.getSSLContext()).setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).build();
        }

        private static SSLContext getSSLContext() {
            try {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                TrustStrategy allTrust = new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                };
                return SSLContexts.custom().useSSL().loadTrustMaterial(trustStore, allTrust).build();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

