/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.ApiBinding;
import org.springframework.social.oauth1.OAuth1Credentials;
import org.springframework.social.oauth1.OAuth1RequestInterceptor;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuth1ApiBinding
implements ApiBinding,
InitializingBean {
    private final OAuth1Credentials credentials;
    private RestTemplate restTemplate;

    protected AbstractOAuth1ApiBinding() {
        this.credentials = null;
        this.restTemplate = this.createRestTemplateWithCulledMessageConverters();
        this.configureRestTemplate(this.restTemplate);
    }

    protected AbstractOAuth1ApiBinding(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        Assert.notNull((Object)consumerKey, (String)"Constructor argument 'consumerKey' cannot be null.");
        Assert.notNull((Object)consumerSecret, (String)"Constructor argument 'consumerSecret' cannot be null.");
        Assert.notNull((Object)accessToken, (String)"Constructor argument 'accessToken' cannot be null.");
        Assert.notNull((Object)accessTokenSecret, (String)"Constructor argument 'accessTokenSecret' cannot be null.");
        this.credentials = new OAuth1Credentials(consumerKey, consumerSecret, accessToken, accessTokenSecret);
        this.restTemplate = this.createRestTemplate(this.credentials);
        this.configureRestTemplate(this.restTemplate);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    public boolean isAuthorized() {
        return this.credentials != null;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getFormMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getJsonMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getByteArrayMessageConverter());
        return messageConverters;
    }

    protected FormHttpMessageConverter getFormMessageConverter() {
        FormHttpMessageConverter converter = new FormHttpMessageConverter();
        converter.setCharset(Charset.forName("UTF-8"));
        ArrayList<Object> partConverters = new ArrayList<Object>();
        partConverters.add(new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        partConverters.add(stringHttpMessageConverter);
        partConverters.add(new ResourceHttpMessageConverter());
        converter.setPartConverters(partConverters);
        return converter;
    }

    protected MappingJackson2HttpMessageConverter getJsonMessageConverter() {
        return new MappingJackson2HttpMessageConverter();
    }

    protected ByteArrayHttpMessageConverter getByteArrayMessageConverter() {
        ByteArrayHttpMessageConverter converter = new ByteArrayHttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.IMAGE_JPEG, MediaType.IMAGE_GIF, MediaType.IMAGE_PNG));
        return converter;
    }

    private RestTemplate createRestTemplate(OAuth1Credentials credentials) {
        RestTemplate client = this.createRestTemplateWithCulledMessageConverters();
        OAuth1RequestInterceptor interceptor = new OAuth1RequestInterceptor(credentials);
        LinkedList<OAuth1RequestInterceptor> interceptors = new LinkedList<OAuth1RequestInterceptor>();
        interceptors.add(interceptor);
        client.setInterceptors(interceptors);
        return client;
    }

    public void afterPropertiesSet() throws Exception {
        this.restTemplate = this.postProcess(this.restTemplate);
        this.postConstructionConfiguration();
    }

    protected RestTemplate postProcess(RestTemplate restTemplate) {
        return restTemplate;
    }

    protected void postConstructionConfiguration() {
    }

    private RestTemplate createRestTemplateWithCulledMessageConverters() {
        RestTemplate client;
        List<HttpMessageConverter<?>> messageConverters = this.getMessageConverters();
        try {
            client = new RestTemplate(messageConverters);
        }
        catch (NoSuchMethodError e) {
            client = new RestTemplate();
            client.setMessageConverters(messageConverters);
        }
        client.setRequestFactory(ClientHttpRequestFactorySelector.getRequestFactory());
        return client;
    }
}

