/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.Checkin;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.PlacesOperations;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlacesTemplate
extends AbstractFacebookOperations
implements PlacesOperations {
    private final GraphApi graphApi;

    public PlacesTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public List<Checkin> getCheckins() {
        return this.getCheckins("me", 0, 25);
    }

    @Override
    public List<Checkin> getCheckins(int offset, int limit) {
        return this.getCheckins("me", offset, limit);
    }

    @Override
    public List<Checkin> getCheckins(String objectId) {
        return this.getCheckins(objectId, 0, 25);
    }

    @Override
    public List<Checkin> getCheckins(String objectId, int offset, int limit) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"offset", (Object)String.valueOf(offset));
        parameters.set((Object)"limit", (Object)String.valueOf(limit));
        parameters.set((Object)"with", (Object)"location");
        return this.graphApi.fetchConnections(objectId, "posts", Checkin.class, (MultiValueMap<String, String>)parameters);
    }

    @Override
    public Checkin getCheckin(String checkinId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(checkinId, Checkin.class);
    }

    @Override
    public String checkin(String placeId, double latitude, double longitude) {
        return this.checkin(placeId, latitude, longitude, null, null);
    }

    @Override
    public String checkin(String placeId, double latitude, double longitude, String message, String ... tags) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"place", (Object)placeId);
        data.set((Object)"coordinates", (Object)("{\"latitude\":\"" + latitude + "\",\"longitude\":\"" + longitude + "\"}"));
        if (message != null) {
            data.set((Object)"message", (Object)message);
        }
        if (tags != null && tags.length > 0) {
            String tagsValue = tags[0];
            for (int i = 1; i < tags.length; ++i) {
                tagsValue = tagsValue + "," + tags[i];
            }
            data.set((Object)"tags", (Object)tagsValue);
        }
        return this.graphApi.publish("me", "feed", (MultiValueMap<String, Object>)data);
    }

    @Override
    public List<Page> search(String query, double latitude, double longitude, long distance) {
        this.requireAuthorization();
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"place");
        queryMap.add((Object)"center", (Object)(latitude + "," + longitude));
        queryMap.add((Object)"distance", (Object)String.valueOf(distance));
        return this.graphApi.fetchConnections("search", null, Page.class, (MultiValueMap<String, String>)queryMap);
    }
}

