/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.net.URI;
import java.util.ArrayList;
import org.springframework.social.facebook.api.FamilyMember;
import org.springframework.social.facebook.api.FriendList;
import org.springframework.social.facebook.api.FriendOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.User;
import org.springframework.social.facebook.api.UserInvitableFriend;
import org.springframework.social.facebook.api.UserTaggableFriend;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FriendTemplate
implements FriendOperations {
    private final GraphApi graphApi;
    private final RestTemplate restTemplate;
    private static final String FULL_PROFILE_FIELDS = "id,name,first_name,last_name,gender,locale,education,work,email,third_party_id,link,timezone,updated_time,verified,about,bio,birthday,location,hometown,interested_in,religion,political,quotes,relationship_status,significant_other,website";

    public FriendTemplate(GraphApi graphApi, RestTemplate restTemplate) {
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
    }

    @Override
    public PagedList<FriendList> getFriendLists() {
        return this.graphApi.fetchConnections("me", "friendlists", FriendList.class, new String[0]);
    }

    @Override
    public FriendList getFriendList(String friendListId) {
        return this.graphApi.fetchObject(friendListId, FriendList.class);
    }

    @Override
    public PagedList<Reference> getFriends() {
        return this.getFriends("me");
    }

    @Override
    public PagedList<String> getFriendIds() {
        return this.getFriendIds("me");
    }

    @Override
    public PagedList<User> getFriendProfiles() {
        return this.getFriendProfiles("me");
    }

    @Override
    public PagedList<User> getFriendProfiles(PagingParameters pagedListParameters) {
        return this.getFriendProfiles("me", pagedListParameters);
    }

    @Override
    public PagedList<Reference> getFriends(String userId) {
        return this.graphApi.fetchConnections(userId, "friends", Reference.class, new String[0]);
    }

    @Override
    public PagedList<String> getFriendIds(String userId) {
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/v2.3/" + userId + "/friends")).queryParam("fields", "id").build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        ArrayNode dataNode = (ArrayNode)responseNode.get("data");
        ArrayList<String> idList = new ArrayList<String>(dataNode.size());
        for (JsonNode entryNode : dataNode) {
            idList.add(entryNode.get("id").textValue());
        }
        Integer totalCount = responseNode.has("summary") && responseNode.get("summary").has("total_count") ? Integer.valueOf(responseNode.get("summary").get("total_count").asInt()) : null;
        return new PagedList<String>(idList, null, null, totalCount);
    }

    @Override
    public PagedList<User> getFriendProfiles(String userId) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"fields", (Object)FULL_PROFILE_FIELDS);
        return this.graphApi.fetchConnections(userId, "friends", User.class, (MultiValueMap<String, String>)parameters);
    }

    @Override
    public PagedList<User> getFriendProfiles(String userId, PagingParameters pagedListParameters) {
        MultiValueMap<String, String> parameters = PagedListUtils.getPagingParameters(pagedListParameters);
        parameters.set((Object)"fields", (Object)FULL_PROFILE_FIELDS);
        return this.graphApi.fetchConnections(userId, "friends", User.class, parameters);
    }

    @Override
    public PagedList<FamilyMember> getFamily() {
        return this.graphApi.fetchConnections("me", "family", FamilyMember.class, new String[0]);
    }

    @Override
    public PagedList<FamilyMember> getFamily(String userId) {
        return this.graphApi.fetchConnections(userId, "family", FamilyMember.class, new String[0]);
    }

    @Override
    public PagedList<UserInvitableFriend> getInvitableFriends() {
        return this.graphApi.fetchConnections("me", "invitable_friends", UserInvitableFriend.class, "id", "name", "first_name", "last_name", "middle_name");
    }

    @Override
    public PagedList<UserTaggableFriend> getTaggableFriends() {
        return this.graphApi.fetchConnections("me", "taggable_friends", UserTaggableFriend.class, "id", "name", "picture", "first_name", "last_name", "middle_name");
    }
}

