/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.web;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.social.facebook.web.SignedRequest;
import org.springframework.social.facebook.web.SignedRequestDecoder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SignedRequestArgumentResolver
implements HandlerMethodArgumentResolver {
    private final SignedRequestDecoder signedRequestDecoder;

    public SignedRequestArgumentResolver(String appSecret) {
        this.signedRequestDecoder = new SignedRequestDecoder(appSecret);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        SignedRequest annotation = (SignedRequest)parameter.getParameterAnnotation(SignedRequest.class);
        return annotation != null;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        SignedRequest annotation = (SignedRequest)parameter.getParameterAnnotation(SignedRequest.class);
        if (annotation == null) {
            return WebArgumentResolver.UNRESOLVED;
        }
        String signedRequest = request.getParameter("signed_request");
        if (signedRequest == null && annotation.required()) {
            throw new IllegalStateException("Required signed_request parameter is missing.");
        }
        if (signedRequest == null) {
            return null;
        }
        Class parameterType = parameter.getParameterType();
        if (MultiValueMap.class.isAssignableFrom(parameterType)) {
            Map map = this.signedRequestDecoder.decodeSignedRequest(signedRequest, Map.class);
            LinkedMultiValueMap mvm = new LinkedMultiValueMap(map.size());
            mvm.setAll(map);
            return mvm;
        }
        return this.signedRequestDecoder.decodeSignedRequest(signedRequest, parameterType);
    }
}

