/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.drive;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.social.google.api.drive.DriveFileParent;
import org.springframework.social.google.api.drive.UserPermission;

public class DriveFile
extends ApiEntity {
    public static final String FOLDER = "application/vnd.google-apps.folder";
    public static final String SHORTCUT = "application/vnd.google-apps.drive-sdk";
    private String title;
    private String description;
    private String selfLink;
    private String alternateLink;
    private String iconLink;
    private String embedLink;
    private String thumbnailLink;
    private String mimeType;
    private String downloadUrl;
    @JsonProperty
    private Labels labels;
    private Date createdDate;
    private Date modifiedDate;
    private Date lastViewedByMeDate;
    private List<DriveFileParent> parents;
    private Map<String, String> exportLinks;
    private UserPermission userPermission;
    private String md5Checksum;
    private long fileSize;
    private long quotaBytesUsed;
    private List<String> ownerNames;
    private String lastModifyingUserName;
    private boolean editable;
    private boolean writersCanShare;
    private boolean appDataContents;
    @JsonProperty
    private IndexableTextObject indexableText;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isFolder() {
        return FOLDER.equals(this.mimeType);
    }

    public boolean isShortcut() {
        return this.mimeType != null && this.mimeType.startsWith(SHORTCUT);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getAlternateLink() {
        return this.alternateLink;
    }

    public String getIconLink() {
        return this.iconLink;
    }

    public String getEmbedLink() {
        return this.embedLink;
    }

    public String getThumbnailLink() {
        return this.thumbnailLink;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public Date getLastViewedByMeDate() {
        return this.lastViewedByMeDate;
    }

    public List<DriveFileParent> getParents() {
        return this.parents;
    }

    public Map<String, String> getExportLinks() {
        return this.exportLinks;
    }

    public UserPermission getUserPermission() {
        return this.userPermission;
    }

    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getQuotaBytesUsed() {
        return this.quotaBytesUsed;
    }

    public List<String> getOwnerNames() {
        return this.ownerNames;
    }

    public String getLastModifyingUserName() {
        return this.lastModifyingUserName;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isWritersCanShare() {
        return this.writersCanShare;
    }

    public boolean isAppDataContents() {
        return this.appDataContents;
    }

    public boolean isStarred() {
        return this.labels.starred;
    }

    public boolean isHidden() {
        return this.labels.hidden;
    }

    public boolean isTrashed() {
        return this.labels.trashed;
    }

    public boolean isRestricted() {
        return this.labels.restricted;
    }

    public boolean isViewed() {
        return this.labels.viewed;
    }

    private static class IndexableTextObject {
        @JsonProperty
        private String text;

        private IndexableTextObject(String text) {
            this.text = text;
        }
    }

    private static class Labels {
        @JsonProperty
        private boolean starred;
        @JsonProperty
        private boolean hidden;
        @JsonProperty
        private boolean trashed;
        @JsonProperty
        private boolean restricted;
        @JsonProperty
        private boolean viewed;

        private Labels() {
        }
    }

    public static class Builder {
        private String title;
        private String description;
        private String indexableText;
        private boolean starred;
        private boolean hidden;
        private boolean trashed;
        private boolean restricted;
        private boolean viewed;
        private Date lastViewedByMeDate;
        private String mimeType;
        private Date modifiedDate;
        private Collection<String> parentIds = new HashSet<String>();

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setIndexableText(String indexableText) {
            this.indexableText = indexableText;
            return this;
        }

        public Builder setStarred(boolean starred) {
            this.starred = starred;
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setTrashed(boolean trashed) {
            this.trashed = trashed;
            return this;
        }

        public Builder setRestricted(boolean restricted) {
            this.restricted = restricted;
            return this;
        }

        public Builder setViewed(boolean viewed) {
            this.viewed = viewed;
            return this;
        }

        public Builder setLastViewedByMeDate(Date lastViewedByMeDate) {
            this.lastViewedByMeDate = lastViewedByMeDate;
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder setModifiedDate(Date modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public Builder setParents(Collection<String> parentIds) {
            this.parentIds = parentIds;
            return this;
        }

        public Builder setParents(String ... parentIds) {
            return this.setParents(Arrays.asList(parentIds));
        }

        public DriveFile build() {
            DriveFile file = new DriveFile();
            file.title = this.title;
            file.description = this.description;
            file.indexableText = new IndexableTextObject(this.indexableText);
            file.labels = new Labels();
            file.labels.starred = this.starred;
            file.labels.hidden = this.hidden;
            file.labels.trashed = this.trashed;
            file.labels.restricted = this.restricted;
            file.labels.viewed = this.viewed;
            file.lastViewedByMeDate = this.lastViewedByMeDate;
            file.mimeType = this.mimeType;
            file.modifiedDate = this.modifiedDate;
            file.parents = new ArrayList();
            for (String parentId : this.parentIds) {
                if (parentId == null) continue;
                file.parents.add(new DriveFileParent(parentId));
            }
            return file;
        }
    }
}

