/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.impl;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.social.MissingAuthorizationException;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractGoogleApiOperations {
    protected final RestTemplate restTemplate;
    protected final boolean isAuthorized;

    protected AbstractGoogleApiOperations(RestTemplate restTemplate, boolean isAuthorized) {
        this.restTemplate = restTemplate;
        this.isAuthorized = isAuthorized;
    }

    protected void requireAuthorization() {
        if (!this.isAuthorized) {
            throw new MissingAuthorizationException("google");
        }
    }

    protected <T> T getEntity(String url, Class<T> type) {
        return (T)this.restTemplate.getForObject(url, type, new Object[0]);
    }

    protected <T> T saveEntity(String url, T entity) {
        return (T)this.restTemplate.postForObject(url, entity, entity.getClass(), new Object[0]);
    }

    protected <T extends ApiEntity> T saveEntity(String baseUrl, T entity) {
        HttpMethod method;
        String url;
        if (StringUtils.hasText((String)entity.getId())) {
            url = baseUrl + '/' + entity.getId();
            method = HttpMethod.PUT;
        } else {
            url = baseUrl;
            method = HttpMethod.POST;
        }
        ResponseEntity response = this.restTemplate.exchange(url, method, new HttpEntity(entity), entity.getClass(), new Object[0]);
        return (T)((ApiEntity)response.getBody());
    }

    protected void deleteEntity(String baseUrl, ApiEntity entity) {
        this.deleteEntity(baseUrl, entity.getId());
    }

    protected void deleteEntity(String baseUrl, String id) {
        this.restTemplate.delete(baseUrl + '/' + id, new Object[0]);
    }

    protected <T> T patch(String url, Object request, Class<T> responseType) {
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PATCH, new HttpEntity(request), responseType, new Object[0]);
        return (T)response.getBody();
    }
}

