/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.Post;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PostMixin
extends LinkedInObjectMixin {
    @JsonProperty
    Date creationTimestamp;
    @JsonProperty
    Post.PostRelation relationToViewer;
    @JsonProperty
    String summary;
    @JsonProperty
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;

    @JsonCreator
    PostMixin(@JsonProperty(value="creator") LinkedInProfile creator, @JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonProperty(value="type") @JsonDeserialize(using=PostTypeDeserializer.class) Post.PostType type) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LikesListDeserializer
    extends JsonDeserializer<List<LinkedInProfile>> {
        private LikesListDeserializer() {
        }

        public List<LinkedInProfile> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new LinkedInModule());
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<LinkedInProfile> likes = new ArrayList<LinkedInProfile>();
            if (jp.hasCurrentToken() && (dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values")) != null) {
                for (JsonNode d : dataNode) {
                    LinkedInProfile p = (LinkedInProfile)mapper.reader((TypeReference)new TypeReference<LinkedInProfile>(){}).readValue(d.path("person"));
                    likes.add(p);
                }
            }
            return likes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PostTypeDeserializer
    extends JsonDeserializer<Post.PostType> {
        private PostTypeDeserializer() {
        }

        public Post.PostType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAs(JsonNode.class);
            return Post.PostType.valueOf(node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }
}

