/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.test.client;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.social.test.client.MockClientHttpRequest;
import org.springframework.util.Assert;

public class MockClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final List<MockClientHttpRequest> expectedRequests = new LinkedList<MockClientHttpRequest>();
    private Iterator<MockClientHttpRequest> requestIterator;

    public MockClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        Assert.notNull((Object)httpMethod, (String)"'httpMethod' must not be null");
        if (this.requestIterator == null) {
            this.requestIterator = this.expectedRequests.iterator();
        }
        if (!this.requestIterator.hasNext()) {
            throw new AssertionError((Object)"No further requests expected");
        }
        MockClientHttpRequest currentRequest = this.requestIterator.next();
        currentRequest.setUri(uri);
        currentRequest.setHttpMethod(httpMethod);
        return currentRequest;
    }

    MockClientHttpRequest expectNewRequest() {
        Assert.state((this.requestIterator == null ? 1 : 0) != 0, (String)"Can not expect another request, the test is already underway");
        MockClientHttpRequest request = new MockClientHttpRequest();
        this.expectedRequests.add(request);
        return request;
    }

    void verifyRequests() {
        if (this.expectedRequests.isEmpty()) {
            return;
        }
        if (this.requestIterator == null || this.requestIterator.hasNext()) {
            throw new AssertionError((Object)"Further request(s) expected");
        }
    }
}

