/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.social.twitter.api.StatusDetails;
import org.springframework.social.twitter.api.TimelineOperations;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.PagingUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimelineTemplate
extends AbstractTwitterOperations
implements TimelineOperations {
    private final RestTemplate restTemplate;

    public TimelineTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser, boolean isAuthorizedForApp) {
        super(isAuthorizedForUser, isAuthorizedForApp);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<Tweet> getHomeTimeline() {
        return this.getHomeTimeline(20, 0L, 0L);
    }

    @Override
    public List<Tweet> getHomeTimeline(int pageSize) {
        return this.getHomeTimeline(pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getHomeTimeline(int pageSize, long sinceId, long maxId) {
        this.requireUserAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, sinceId, maxId);
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/home_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline() {
        return this.getUserTimeline(20, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(int pageSize) {
        return this.getUserTimeline(pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(int pageSize, long sinceId, long maxId) {
        this.requireUserAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, sinceId, maxId);
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName) {
        return this.getUserTimeline(screenName, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName, int pageSize) {
        return this.getUserTimeline(screenName, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName, int pageSize, long sinceId, long maxId) {
        this.requireEitherUserOrAppAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, sinceId, maxId);
        parameters.set((Object)"screen_name", (Object)screenName);
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId) {
        return this.getUserTimeline(userId, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId, int pageSize) {
        return this.getUserTimeline(userId, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId, int pageSize, long sinceId, long maxId) {
        this.requireEitherUserOrAppAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, sinceId, maxId);
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getMentions() {
        return this.getMentions(20, 0L, 0L);
    }

    @Override
    public List<Tweet> getMentions(int pageSize) {
        return this.getMentions(pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getMentions(int pageSize, long sinceId, long maxId) {
        this.requireUserAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, sinceId, maxId);
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/mentions_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetsOfMe() {
        return this.getRetweetsOfMe(1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetsOfMe(int page, int pageSize) {
        return this.getRetweetsOfMe(page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetsOfMe(int page, int pageSize, long sinceId, long maxId) {
        this.requireUserAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweets_of_me.json", parameters), TweetList.class);
    }

    @Override
    public Tweet getStatus(long tweetId) {
        this.requireEitherUserOrAppAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"include_entities", (Object)"true");
        return (Tweet)this.restTemplate.getForObject(this.buildUri("statuses/show/" + tweetId + ".json", (MultiValueMap<String, String>)parameters), Tweet.class);
    }

    @Override
    public Tweet updateStatus(String message) {
        return this.updateStatus(message, new StatusDetails());
    }

    @Override
    public Tweet updateStatus(String message, Resource media) {
        return this.updateStatus(message, media, new StatusDetails());
    }

    @Override
    public Tweet updateStatus(String message, StatusDetails details) {
        this.requireUserAuthorization();
        LinkedMultiValueMap tweetParams = new LinkedMultiValueMap();
        tweetParams.add((Object)"status", (Object)message);
        tweetParams.putAll(details.toParameterMap());
        return (Tweet)this.restTemplate.postForObject(this.buildUri("statuses/update.json"), (Object)tweetParams, Tweet.class);
    }

    @Override
    public Tweet updateStatus(String message, Resource media, StatusDetails details) {
        this.requireUserAuthorization();
        LinkedMultiValueMap tweetParams = new LinkedMultiValueMap();
        tweetParams.add((Object)"status", (Object)message);
        tweetParams.add((Object)"media", (Object)media);
        tweetParams.putAll(details.toParameterMap());
        return (Tweet)this.restTemplate.postForObject(this.buildUri("statuses/update_with_media.json"), (Object)tweetParams, Tweet.class);
    }

    @Override
    public void deleteStatus(long tweetId) {
        this.requireUserAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("statuses/destroy/" + tweetId + ".json"), (Object)data, String.class);
    }

    @Override
    public void retweet(long tweetId) {
        this.requireUserAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("statuses/retweet/" + tweetId + ".json"), (Object)data, String.class);
    }

    @Override
    public List<Tweet> getRetweets(long tweetId) {
        return this.getRetweets(tweetId, 100);
    }

    @Override
    public List<Tweet> getRetweets(long tweetId, int count) {
        this.requireEitherUserOrAppAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"count", (Object)String.valueOf(count));
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweets/" + tweetId + ".json", (MultiValueMap<String, String>)parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getFavorites() {
        return this.getFavorites(20);
    }

    @Override
    public List<Tweet> getFavorites(int pageSize) {
        this.requireUserAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, 0L, 0L);
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("favorites/list.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getFavorites(long userId) {
        return this.getFavorites(userId, 20);
    }

    @Override
    public List<Tweet> getFavorites(long userId, int pageSize) {
        this.requireEitherUserOrAppAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, 0L, 0L);
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("favorites/list.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getFavorites(String screenName) {
        return this.getFavorites(screenName, 20);
    }

    @Override
    public List<Tweet> getFavorites(String screenName, int pageSize) {
        this.requireEitherUserOrAppAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(pageSize, 0L, 0L);
        parameters.set((Object)"screen_name", (Object)screenName);
        parameters.set((Object)"include_entities", (Object)"true");
        return (List)this.restTemplate.getForObject(this.buildUri("favorites/list.json", parameters), TweetList.class);
    }

    @Override
    public void addToFavorites(long tweetId) {
        this.requireUserAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"id", (Object)String.valueOf(tweetId));
        this.restTemplate.postForObject(this.buildUri("favorites/create.json"), (Object)data, String.class);
    }

    @Override
    public void removeFromFavorites(long tweetId) {
        this.requireUserAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"id", (Object)String.valueOf(tweetId));
        this.restTemplate.postForObject(this.buildUri("favorites/destroy.json"), (Object)data, String.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TweetList
    extends ArrayList<Tweet> {
        private TweetList() {
        }
    }
}

