/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web.thymeleaf;

import org.springframework.context.ApplicationContext;
import org.springframework.social.connect.ConnectionRepository;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;
import org.thymeleaf.spring4.context.SpringWebContext;

class ConnectedAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    public ConnectedAttrProcessor() {
        super("connected");
    }

    public int getPrecedence() {
        return 300;
    }

    protected boolean isVisible(Arguments arguments, Element element, String attributeName) {
        String providerId = element.getAttributeValue(attributeName);
        if (providerId == null || providerId.trim().equals("")) {
            return false;
        }
        ConnectionRepository connectionRepository = this.getConnectionRepository(arguments.getContext());
        return connectionRepository.findConnections(providerId).size() > 0;
    }

    private ConnectionRepository getConnectionRepository(IContext context) {
        ApplicationContext applicationContext = this.getSpringApplicationContextFromThymeleafContext(context);
        ConnectionRepository connectionRepository = (ConnectionRepository)applicationContext.getBean(ConnectionRepository.class);
        return connectionRepository;
    }

    private ApplicationContext getSpringApplicationContextFromThymeleafContext(IContext context) {
        if (!(context instanceof SpringWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a Spring web context (implementation of " + SpringWebContext.class.getName() + ". Spring Social integration can only be used in " + "web environements with a Spring application context.");
        }
        SpringWebContext springContext = (SpringWebContext)context;
        return springContext.getApplicationContext();
    }
}

