/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.Actions;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.config.builders.StateMachineStateBuilder;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.configurers.StateConfigurer;
import org.springframework.statemachine.config.model.StateData;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.state.PseudoStateKind;

public class DefaultStateConfigurer<S, E>
extends AnnotationConfigurerAdapter<StatesData<S, E>, StateMachineStateConfigurer<S, E>, StateMachineStateBuilder<S, E>>
implements StateConfigurer<S, E> {
    private Object parent;
    private Object region = UUID.randomUUID().toString();
    private final Map<S, StateData<S, E>> incomplete = new HashMap<S, StateData<S, E>>();
    private S initialState;
    private Action<S, E> initialAction;
    private final Collection<S> ends = new ArrayList<S>();
    private S history;
    private StateConfigurer.History historyType;
    private final Collection<S> choices = new ArrayList<S>();
    private final Collection<S> junctions = new ArrayList<S>();
    private final Collection<S> forks = new ArrayList<S>();
    private final Collection<S> joins = new ArrayList<S>();
    private final Collection<S> exits = new ArrayList<S>();
    private final Collection<S> entrys = new ArrayList<S>();
    private final Map<S, StateMachine<S, E>> submachines = new HashMap<S, StateMachine<S, E>>();
    private final Map<S, StateMachineFactory<S, E>> submachinefactories = new HashMap<S, StateMachineFactory<S, E>>();

    @Override
    public void configure(StateMachineStateBuilder<S, E> builder) throws Exception {
        ArrayList stateDatas = new ArrayList();
        for (StateData<S, E> s : this.incomplete.values()) {
            s.setParent(this.parent);
            stateDatas.add(s);
            if (s.getState() == this.initialState) {
                s.setInitial(true);
                s.setInitialAction(this.initialAction);
            }
            if (this.ends.contains(s.getState())) {
                s.setEnd(true);
            }
            if (this.choices.contains(s.getState())) {
                s.setPseudoStateKind(PseudoStateKind.CHOICE);
            } else if (this.junctions.contains(s.getState())) {
                s.setPseudoStateKind(PseudoStateKind.JUNCTION);
            } else if (this.forks.contains(s.getState())) {
                s.setPseudoStateKind(PseudoStateKind.FORK);
            } else if (this.joins.contains(s.getState())) {
                s.setPseudoStateKind(PseudoStateKind.JOIN);
            } else if (this.entrys.contains(s.getState())) {
                s.setPseudoStateKind(PseudoStateKind.ENTRY);
            } else if (this.exits.contains(s.getState())) {
                s.setPseudoStateKind(PseudoStateKind.EXIT);
            }
            if (s.getState() == this.history) {
                if (StateConfigurer.History.SHALLOW == this.historyType) {
                    s.setPseudoStateKind(PseudoStateKind.HISTORY_SHALLOW);
                } else if (StateConfigurer.History.DEEP == this.historyType) {
                    s.setPseudoStateKind(PseudoStateKind.HISTORY_DEEP);
                }
            }
            s.setSubmachine(this.submachines.get(s.getState()));
            s.setSubmachineFactory(this.submachinefactories.get(s.getState()));
        }
        builder.addStateData(stateDatas);
    }

    @Override
    public StateConfigurer<S, E> initial(S initial) {
        this.initialState = initial;
        this.state(initial);
        return this;
    }

    @Override
    public StateConfigurer<S, E> initial(S initial, Action<S, E> action) {
        this.initialAction = action;
        return this.initial(initial);
    }

    @Override
    public StateConfigurer<S, E> parent(S state) {
        this.parent = state;
        return this;
    }

    @Override
    public StateConfigurer<S, E> region(String id) {
        this.region = id;
        return this;
    }

    @Override
    public StateConfigurer<S, E> end(S end) {
        this.ends.add(end);
        this.state(end);
        return this;
    }

    @Override
    public StateConfigurer<S, E> state(S state) {
        return this.state(state, (Object[])null);
    }

    @Override
    public StateConfigurer<S, E> state(S state, StateMachine<S, E> stateMachine) {
        this.state(state);
        this.submachines.put(state, stateMachine);
        return this;
    }

    @Override
    public StateConfigurer<S, E> state(S state, StateMachineFactory<S, E> stateMachineFactory) {
        this.state(state);
        this.submachinefactories.put(state, stateMachineFactory);
        return this;
    }

    @Override
    public StateConfigurer<S, E> state(S state, Collection<? extends Action<S, E>> stateActions) {
        this.addIncomplete(null, state, null, null, null, stateActions);
        return this;
    }

    @Override
    public StateConfigurer<S, E> state(S state, Action<S, E> stateAction) {
        ArrayList<Action<S, E>> stateActions = null;
        if (stateAction != null) {
            stateActions = new ArrayList<Action<S, E>>(1);
            stateActions.add(stateAction);
        }
        return this.state(state, (Collection<? extends Action<S, E>>)stateActions);
    }

    @Override
    public StateConfigurer<S, E> stateDo(S state, Action<S, E> action) {
        return this.stateDo(state, action, null);
    }

    @Override
    public StateConfigurer<S, E> stateDo(S state, Action<S, E> action, Action<S, E> error) {
        ArrayList<Action<S, E>> stateActions = null;
        if (action != null) {
            stateActions = new ArrayList<Action<S, E>>(1);
            stateActions.add(error != null ? Actions.errorCallingAction(action, error) : action);
        }
        return this.state(state, (Collection<? extends Action<S, E>>)stateActions);
    }

    @Override
    public StateConfigurer<S, E> state(S state, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions) {
        this.addIncomplete(null, state, null, entryActions, exitActions, null);
        return this;
    }

    @Override
    public StateConfigurer<S, E> state(S state, Action<S, E> entryAction, Action<S, E> exitAction) {
        ArrayList<Action<S, E>> entryActions = null;
        if (entryAction != null) {
            entryActions = new ArrayList<Action<S, E>>(1);
            entryActions.add(entryAction);
        }
        ArrayList<Action<S, E>> exitActions = null;
        if (exitAction != null) {
            exitActions = new ArrayList<Action<S, E>>(1);
            exitActions.add(exitAction);
        }
        return this.state(state, (Collection<? extends Action<S, E>>)entryActions, (Collection<? extends Action<S, E>>)exitActions);
    }

    @Override
    public StateConfigurer<S, E> stateEntry(S state, Action<S, E> action) {
        return this.state(state, action, null);
    }

    @Override
    public StateConfigurer<S, E> stateEntry(S state, Action<S, E> action, Action<S, E> error) {
        ArrayList<Action<S, E>> entryActions = null;
        if (action != null) {
            entryActions = new ArrayList<Action<S, E>>(1);
            entryActions.add(error != null ? Actions.errorCallingAction(action, error) : action);
        }
        return this.state(state, entryActions, null);
    }

    @Override
    public StateConfigurer<S, E> stateExit(S state, Action<S, E> action) {
        return this.state(state, null, action);
    }

    @Override
    public StateConfigurer<S, E> stateExit(S state, Action<S, E> action, Action<S, E> error) {
        ArrayList<Action<S, E>> exitActions = null;
        if (action != null) {
            exitActions = new ArrayList<Action<S, E>>(1);
            exitActions.add(error != null ? Actions.errorCallingAction(action, error) : action);
        }
        return this.state(state, null, exitActions);
    }

    @Override
    public StateConfigurer<S, E> state(S state, E ... deferred) {
        List<E> d = null;
        if (deferred != null) {
            d = Arrays.asList(deferred);
        }
        this.addIncomplete(null, state, d, null, null, null);
        return this;
    }

    @Override
    public StateConfigurer<S, E> states(Set<S> states) {
        for (S s : states) {
            this.state(s);
        }
        return this;
    }

    @Override
    public StateConfigurer<S, E> choice(S choice) {
        this.state(choice);
        this.choices.add(choice);
        return this;
    }

    @Override
    public StateConfigurer<S, E> junction(S junction) {
        this.state(junction);
        this.junctions.add(junction);
        return this;
    }

    @Override
    public StateConfigurer<S, E> fork(S fork) {
        this.state(fork);
        this.forks.add(fork);
        return this;
    }

    @Override
    public StateConfigurer<S, E> join(S join) {
        this.state(join);
        this.joins.add(join);
        return this;
    }

    @Override
    public StateConfigurer<S, E> history(S history, StateConfigurer.History type) {
        this.history = history;
        this.historyType = type;
        this.state(history);
        return this;
    }

    @Override
    public StateConfigurer<S, E> entry(S entry) {
        this.state(entry);
        this.entrys.add(entry);
        return this;
    }

    @Override
    public StateConfigurer<S, E> exit(S exit) {
        this.state(exit);
        this.exits.add(exit);
        return this;
    }

    private void addIncomplete(Object parent, S state, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, Collection<? extends Action<S, E>> stateActions) {
        StateData<S, E> stateData = this.incomplete.get(state);
        if (stateData == null) {
            stateData = new StateData<S, E>(parent, this.region, state, deferred, entryActions, exitActions);
            this.incomplete.put(state, stateData);
        }
        if (stateData.getParent() == null) {
            stateData.setParent(parent);
        }
        if (stateData.getRegion() == null) {
            stateData.setRegion(this.region);
        }
        if (stateData.getDeferred() == null) {
            stateData.setDeferred(deferred);
        }
        if (stateData.getEntryActions() == null) {
            stateData.setEntryActions(entryActions);
        }
        if (stateData.getExitActions() == null) {
            stateData.setExitActions(exitActions);
        }
        if (stateData.getStateActions() == null) {
            stateData.setStateActions(stateActions);
        }
    }
}

