/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.security;

import java.util.Collection;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.statemachine.security.DefaultTransitionSecurityExpressionHandler;
import org.springframework.statemachine.security.TransitionExpressionConfigAttribute;
import org.springframework.statemachine.transition.Transition;

public class TransitionExpressionVoter
implements AccessDecisionVoter<Transition<?, ?>> {
    private final SecurityExpressionHandler<Transition<?, ?>> expressionHandler = new DefaultTransitionSecurityExpressionHandler();

    public boolean supports(ConfigAttribute attribute) {
        return attribute instanceof TransitionExpressionConfigAttribute;
    }

    public boolean supports(Class<?> clazz) {
        return Transition.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Transition<?, ?> object, Collection<ConfigAttribute> attributes) {
        TransitionExpressionConfigAttribute teca = this.findConfigAttribute(attributes);
        if (teca == null) {
            return 0;
        }
        EvaluationContext ctx = this.expressionHandler.createEvaluationContext(authentication, object);
        return ExpressionUtils.evaluateAsBoolean((Expression)teca.getAuthorizeExpression(), (EvaluationContext)ctx) ? 1 : -1;
    }

    private TransitionExpressionConfigAttribute findConfigAttribute(Collection<ConfigAttribute> attributes) {
        for (ConfigAttribute attribute : attributes) {
            if (!(attribute instanceof TransitionExpressionConfigAttribute)) continue;
            return (TransitionExpressionConfigAttribute)attribute;
        }
        return null;
    }
}

