/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.StateMachineUtils;

public class RegionState<S, E>
extends AbstractState<S, E> {
    public RegionState(S id, Collection<Region<S, E>> regions) {
        super(id, null, null, null, null, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, Collection<E> deferred) {
        super(id, deferred, null, null, null, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, PseudoState<S, E> pseudoState) {
        super(id, null, null, null, pseudoState, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState) {
        super(id, deferred, entryActions, exitActions, pseudoState, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions) {
        super(id, deferred, entryActions, exitActions, null, regions);
    }

    @Override
    public boolean sendEvent(Message<E> event) {
        boolean accept = false;
        if (this.getRegions() != null) {
            for (Region region : this.getRegions()) {
                accept |= region.sendEvent(event);
            }
        }
        return accept;
    }

    @Override
    public boolean shouldDefer(Message<E> event) {
        boolean defer = true;
        if (this.getRegions() != null) {
            for (Region r : this.getRegions()) {
                State state = r.getState();
                if (state == null) continue;
                if (state.getDeferredEvents().contains(event.getPayload())) {
                    defer &= true;
                    continue;
                }
                defer = false;
            }
        }
        return defer;
    }

    @Override
    public void exit(StateContext<S, E> context) {
        super.exit(context);
        for (Region region : this.getRegions()) {
            if (region.getState() != null) {
                region.getState().exit(context);
            }
            region.stop();
        }
        for (Action action : this.getExitActions()) {
            this.executeAction(action, context);
        }
    }

    @Override
    public void entry(StateContext<S, E> context) {
        super.entry(context);
        for (Action action : this.getEntryActions()) {
            this.executeAction(action, context);
        }
        if (this.getPseudoState() != null && this.getPseudoState().getKind() == PseudoStateKind.INITIAL) {
            for (Region region : this.getRegions()) {
                boolean start = true;
                if (StateMachineUtils.containsAtleastOne(region.getStates(), context.getTargets())) {
                    start = false;
                }
                if (!start) continue;
                region.start();
            }
        } else {
            for (Region region : this.getRegions()) {
                if (region.getState() == null) continue;
                region.getState().entry(context);
            }
        }
    }

    @Override
    public Collection<S> getIds() {
        ArrayList ids = new ArrayList();
        if (this.getId() != null) {
            ids.add(this.getId());
        }
        for (Region r : this.getRegions()) {
            State s = r.getState();
            if (s == null) continue;
            ids.addAll(s.getIds());
        }
        return ids;
    }

    @Override
    public Collection<State<S, E>> getStates() {
        ArrayList states = new ArrayList();
        states.add(this);
        for (Region r : this.getRegions()) {
            for (State s : r.getStates()) {
                states.addAll(s.getStates());
            }
        }
        return states;
    }

    @Override
    public String toString() {
        return "RegionState [getIds()=" + this.getIds() + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
    }
}

