/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.access.StateMachineAccess;
import org.springframework.statemachine.access.StateMachineAccessor;
import org.springframework.statemachine.access.StateMachineFunction;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.ActionListener;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.monitor.StateMachineMonitor;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.ForkPseudoState;
import org.springframework.statemachine.state.HistoryPseudoState;
import org.springframework.statemachine.state.JoinPseudoState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateContext;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.PseudoStateListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateListenerAdapter;
import org.springframework.statemachine.support.DefaultExtendedState;
import org.springframework.statemachine.support.DefaultStateContext;
import org.springframework.statemachine.support.DefaultStateMachineExecutor;
import org.springframework.statemachine.support.StateMachineExecutor;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineObjectSupport;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.transition.InitialTransition;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionConflictPolicy;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.statemachine.trigger.DefaultTriggerContext;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractStateMachine<S, E>
extends StateMachineObjectSupport<S, E>
implements StateMachine<S, E>,
StateMachineAccess<S, E> {
    private static final Log log = LogFactory.getLog(AbstractStateMachine.class);
    private final Collection<State<S, E>> states;
    private final Collection<Transition<S, E>> transitions;
    private final State<S, E> initialState;
    private final Transition<S, E> initialTransition;
    private final Message<E> initialEvent;
    private ExtendedState extendedState;
    private TransitionConflictPolicy transitionConflictPolicy;
    private volatile State<S, E> currentState;
    private volatile State<S, E> lastState;
    private volatile Exception currentError;
    private volatile PseudoState<S, E> history;
    private final Map<Trigger<S, E>, Transition<S, E>> triggerToTransitionMap = new HashMap<Trigger<S, E>, Transition<S, E>>();
    private final List<Transition<S, E>> triggerlessTransitions = new ArrayList<Transition<S, E>>();
    private StateMachine<S, E> relay;
    private StateMachineExecutor<S, E> stateMachineExecutor;
    private Boolean initialEnabled = null;
    private final UUID uuid;
    private String id;
    private volatile Message<E> forwardedInitialEvent;
    private StateMachine<S, E> parentMachine;

    public AbstractStateMachine(Collection<State<S, E>> states, Collection<Transition<S, E>> transitions, State<S, E> initialState) {
        this(states, transitions, initialState, new DefaultExtendedState());
    }

    public AbstractStateMachine(Collection<State<S, E>> states, Collection<Transition<S, E>> transitions, State<S, E> initialState, ExtendedState extendedState) {
        this(states, transitions, initialState, null, null, extendedState, null);
    }

    public AbstractStateMachine(Collection<State<S, E>> states, Collection<Transition<S, E>> transitions, State<S, E> initialState, Transition<S, E> initialTransition, Message<E> initialEvent, ExtendedState extendedState, UUID uuid) {
        this.uuid = uuid == null ? UUID.randomUUID() : uuid;
        this.states = states;
        this.transitions = transitions;
        this.initialState = initialState;
        this.initialEvent = initialEvent;
        this.extendedState = extendedState != null ? extendedState : new DefaultExtendedState();
        this.initialTransition = initialTransition == null ? new InitialTransition<S, E>(initialState) : initialTransition;
    }

    @Override
    public State<S, E> getState() {
        State<S, E> s = this.lastState;
        if (s != null && this.isComplete()) {
            return s;
        }
        return this.currentState;
    }

    @Override
    public State<S, E> getInitialState() {
        return this.initialState;
    }

    @Override
    public ExtendedState getExtendedState() {
        return this.extendedState;
    }

    public void setHistoryState(PseudoState<S, E> history) {
        this.history = history;
    }

    public PseudoState<S, E> getHistoryState() {
        return this.history;
    }

    @Override
    public boolean sendEvent(Message<E> event) {
        return this.sendEventInternal(event);
    }

    @Override
    protected void notifyEventNotAccepted(StateContext<S, E> stateContext) {
        if (this.parentMachine == null) {
            super.notifyEventNotAccepted(stateContext);
        }
    }

    @Override
    public boolean sendEvent(E event) {
        return this.sendEvent((E)MessageBuilder.withPayload(event).build());
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        Assert.notNull(this.initialState, (String)"Initial state must be set");
        Assert.state((this.initialState.getPseudoState() != null && this.initialState.getPseudoState().getKind() == PseudoStateKind.INITIAL ? 1 : 0) != 0, (String)"Initial state's pseudostate kind must be INITIAL");
        this.lastState = null;
        this.extendedState.setExtendedStateChangeListener(new ExtendedState.ExtendedStateChangeListener(){

            @Override
            public void changed(Object key, Object value) {
                AbstractStateMachine.this.notifyExtendedStateChanged(key, value, AbstractStateMachine.this.buildStateContext(StateContext.Stage.EXTENDED_STATE_CHANGED, null, null, AbstractStateMachine.this.getRelayStateMachine()));
            }
        });
        for (Transition<S, E> transition : this.transitions) {
            Trigger<S, E> trigger = transition.getTrigger();
            if (trigger != null) {
                this.triggerToTransitionMap.put(trigger, transition);
                continue;
            }
            this.triggerlessTransitions.add(transition);
        }
        for (final State state : this.states) {
            state.addStateListener(new StateListenerAdapter<S, E>(){

                @Override
                public void onComplete(StateContext<S, E> context) {
                    ((AbstractStateMachine)AbstractStateMachine.this.getRelayStateMachine()).executeTriggerlessTransitions(AbstractStateMachine.this, context, state);
                }
            });
            if (state.isSubmachineState()) {
                StateMachine stateMachine = ((AbstractState)state).getSubmachine();
                stateMachine.addStateListener(new StateMachineObjectSupport.StateMachineListenerRelay());
            } else if (state.isOrthogonal()) {
                Collection collection = ((AbstractState)state).getRegions();
                for (Region region : collection) {
                    region.addStateListener(new StateMachineObjectSupport.StateMachineListenerRelay());
                }
            }
            if (state.getPseudoState() == null || state.getPseudoState().getKind() != PseudoStateKind.HISTORY_DEEP && state.getPseudoState().getKind() != PseudoStateKind.HISTORY_DEEP) continue;
            this.history = state.getPseudoState();
        }
        DefaultStateMachineExecutor<S, E> executor = new DefaultStateMachineExecutor<S, E>(this, this.getRelayStateMachine(), this.transitions, this.triggerToTransitionMap, this.triggerlessTransitions, this.initialTransition, this.initialEvent, this.transitionConflictPolicy);
        if (this.getBeanFactory() != null) {
            executor.setBeanFactory(this.getBeanFactory());
        }
        if (this.getTaskExecutor() != null) {
            if (this.parentMachine != null) {
                executor.setTaskExecutor((TaskExecutor)new SyncTaskExecutor());
            } else {
                executor.setTaskExecutor(this.getTaskExecutor());
            }
        }
        executor.afterPropertiesSet();
        executor.setStateMachineExecutorTransit(new StateMachineExecutor.StateMachineExecutorTransit<S, E>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transit(Transition<S, E> t, StateContext<S, E> ctx, Message<E> message) {
                if (AbstractStateMachine.this.currentState != null && AbstractStateMachine.this.currentState.isSubmachineState()) {
                    StateMachine submachine = ((AbstractState)AbstractStateMachine.this.currentState).getSubmachine();
                    Lock lock = ((AbstractStateMachine)submachine).getStateMachineExecutor().getLock();
                    try {
                        lock.lock();
                    }
                    finally {
                        lock.unlock();
                    }
                }
                long now = System.currentTimeMillis();
                AbstractStateMachine.this.notifyTransitionStart(AbstractStateMachine.this.buildStateContext(StateContext.Stage.TRANSITION_START, message, t, AbstractStateMachine.this.getRelayStateMachine()));
                try {
                    t.executeTransitionActions(ctx);
                }
                catch (Exception e) {
                    log.warn((Object)("Aborting as transition " + t), (Throwable)e);
                    throw new StateMachineException("Aborting as transition " + t + " caused error ", e);
                }
                AbstractStateMachine.this.notifyTransition(AbstractStateMachine.this.buildStateContext(StateContext.Stage.TRANSITION, message, t, AbstractStateMachine.this.getRelayStateMachine()));
                if (t.getTarget().getPseudoState() != null && t.getTarget().getPseudoState().getKind() == PseudoStateKind.JOIN) {
                    AbstractStateMachine.this.exitFromState(t.getSource(), message, t, AbstractStateMachine.this.getRelayStateMachine());
                } else if (t.getKind() == TransitionKind.INITIAL) {
                    AbstractStateMachine.this.switchToState(t.getTarget(), message, t, AbstractStateMachine.this.getRelayStateMachine());
                    AbstractStateMachine.this.notifyStateMachineStarted(AbstractStateMachine.this.buildStateContext(StateContext.Stage.STATEMACHINE_START, message, t, AbstractStateMachine.this.getRelayStateMachine()));
                } else if (t.getKind() != TransitionKind.INTERNAL) {
                    AbstractStateMachine.this.switchToState(t.getTarget(), message, t, AbstractStateMachine.this.getRelayStateMachine());
                }
                AbstractStateMachine.this.notifyTransitionEnd(AbstractStateMachine.this.buildStateContext(StateContext.Stage.TRANSITION_END, message, t, AbstractStateMachine.this.getRelayStateMachine()));
                AbstractStateMachine.this.notifyTransitionMonitor(AbstractStateMachine.this.getRelayStateMachine(), t, System.currentTimeMillis() - now);
            }
        });
        this.stateMachineExecutor = executor;
        for (Transition<S, E> transition : this.getTransitions()) {
            transition.addActionListener(new ActionListener<S, E>(){

                @Override
                public void onExecute(StateMachine<S, E> stateMachine, Action<S, E> action, long duration) {
                    AbstractStateMachine.this.notifyActionMonitor(stateMachine, action, duration);
                }
            });
        }
        for (State<S, E> state : this.getStates()) {
            state.addActionListener(new ActionListener<S, E>(){

                @Override
                public void onExecute(StateMachine<S, E> stateMachine, Action<S, E> action, long duration) {
                    AbstractStateMachine.this.notifyActionMonitor(stateMachine, action, duration);
                }
            });
        }
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getBeanFactory() == null) {
            super.setBeanFactory(beanFactory);
            if (this.stateMachineExecutor instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.stateMachineExecutor).setBeanFactory(beanFactory);
            }
        }
    }

    @Override
    protected void doStart() {
        super.doStart();
        if (this.currentState != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"State already set, disabling initial");
            }
            this.registerPseudoStateListener();
            this.stateMachineExecutor.setInitialEnabled(false);
            this.stateMachineExecutor.start();
            StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATEMACHINE_START, null, null, this.getRelayStateMachine());
            this.notifyStateMachineStarted(stateContext);
            if (this.currentState != null && this.currentState.isSubmachineState()) {
                StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
                submachine.start();
            } else if (this.currentState != null && this.currentState.isOrthogonal()) {
                Collection regions = ((AbstractState)this.currentState).getRegions();
                for (Region region : regions) {
                    region.start();
                }
            }
            return;
        }
        this.registerPseudoStateListener();
        if (this.initialEnabled != null && !this.initialEnabled.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initial disable asked, disabling initial");
            }
            this.stateMachineExecutor.setInitialEnabled(false);
        } else {
            this.stateMachineExecutor.setForwardedInitialEvent(this.forwardedInitialEvent);
        }
        this.stateMachineExecutor.start();
    }

    @Override
    protected void doStop() {
        this.stateMachineExecutor.stop();
        this.notifyStateMachineStopped(this.buildStateContext(StateContext.Stage.STATEMACHINE_STOP, null, null, this));
        this.lastState = this.currentState;
        this.currentState = null;
        this.initialEnabled = null;
        log.debug((Object)("Stop complete " + this));
    }

    @Override
    protected void doDestroy() {
        this.stop();
    }

    @Override
    public void setStateMachineError(Exception exception) {
        this.currentError = exception == null ? null : (exception = this.getStateMachineInterceptors().stateMachineError(this, exception));
        if (this.currentError != null) {
            this.notifyStateMachineError(this.buildStateContext(StateContext.Stage.STATEMACHINE_ERROR, null, null, this, this.currentError));
        }
    }

    @Override
    public boolean hasStateMachineError() {
        return this.currentError != null;
    }

    @Override
    public void addStateListener(StateMachineListener<S, E> listener) {
        this.getStateListener().register(listener);
    }

    @Override
    public void removeStateListener(StateMachineListener<S, E> listener) {
        this.getStateListener().unregister(listener);
    }

    @Override
    public boolean isComplete() {
        State<S, E> s = this.currentState;
        if (s == null) {
            return !this.isRunning();
        }
        return s != null && s.getPseudoState() != null && s.getPseudoState().getKind() == PseudoStateKind.END;
    }

    @Override
    public Collection<State<S, E>> getStates() {
        return Collections.unmodifiableCollection(this.states);
    }

    @Override
    public Collection<Transition<S, E>> getTransitions() {
        return this.transitions;
    }

    @Override
    public void setInitialEnabled(boolean enabled) {
        this.initialEnabled = enabled;
    }

    @Override
    public StateMachineAccessor<S, E> getStateMachineAccessor() {
        return new StateMachineAccessor<S, E>(){

            @Override
            public void doWithAllRegions(StateMachineFunction<StateMachineAccess<S, E>> stateMachineAccess) {
                stateMachineAccess.apply(AbstractStateMachine.this);
                for (State state : AbstractStateMachine.this.states) {
                    if (state.isSubmachineState()) {
                        StateMachine submachine = ((AbstractState)state).getSubmachine();
                        submachine.getStateMachineAccessor().doWithAllRegions(stateMachineAccess);
                        continue;
                    }
                    if (!state.isOrthogonal()) continue;
                    Collection regions = ((AbstractState)state).getRegions();
                    for (Region region : regions) {
                        ((StateMachine)region).getStateMachineAccessor().doWithAllRegions(stateMachineAccess);
                    }
                }
            }

            @Override
            public List<StateMachineAccess<S, E>> withAllRegions() {
                ArrayList list = new ArrayList();
                list.add(AbstractStateMachine.this);
                for (State state : AbstractStateMachine.this.states) {
                    if (state.isSubmachineState()) {
                        StateMachine submachine = ((AbstractState)state).getSubmachine();
                        if (!(submachine instanceof StateMachineAccess)) continue;
                        list.add((StateMachineAccess)((Object)submachine));
                        continue;
                    }
                    if (!state.isOrthogonal()) continue;
                    Collection regions = ((AbstractState)state).getRegions();
                    for (Region region : regions) {
                        list.add((StateMachineAccess)((Object)region));
                    }
                }
                return list;
            }

            @Override
            public void doWithRegion(StateMachineFunction<StateMachineAccess<S, E>> stateMachineAccess) {
                stateMachineAccess.apply(AbstractStateMachine.this);
            }

            @Override
            public StateMachineAccess<S, E> withRegion() {
                return AbstractStateMachine.this;
            }
        };
    }

    @Override
    public void setRelay(StateMachine<S, E> stateMachine) {
        this.relay = stateMachine;
    }

    @Override
    public void setParentMachine(StateMachine<S, E> parentMachine) {
        this.parentMachine = parentMachine;
    }

    @Override
    protected void stateChangedInRelay() {
        this.stateMachineExecutor.execute();
    }

    @Override
    public void setForwardedInitialEvent(Message<E> message) {
        this.forwardedInitialEvent = message;
    }

    public void setTransitionConflightPolicy(TransitionConflictPolicy transitionConflictPolicy) {
        this.transitionConflictPolicy = transitionConflictPolicy;
    }

    private boolean sendEventInternal(Message<E> event) {
        if (this.hasStateMachineError()) {
            this.notifyEventNotAccepted(this.buildStateContext(StateContext.Stage.EVENT_NOT_ACCEPTED, event, null, this.getRelayStateMachine(), this.getState(), null));
            return false;
        }
        try {
            event = this.getStateMachineInterceptors().preEvent(event, this);
        }
        catch (Exception e) {
            log.info((Object)("Event " + event + " threw exception in interceptors, not accepting event"));
            this.notifyEventNotAccepted(this.buildStateContext(StateContext.Stage.EVENT_NOT_ACCEPTED, event, null, this.getRelayStateMachine(), this.getState(), null));
            return false;
        }
        if (this.isComplete() || !this.isRunning()) {
            this.notifyEventNotAccepted(this.buildStateContext(StateContext.Stage.EVENT_NOT_ACCEPTED, event, null, this.getRelayStateMachine(), this.getState(), null));
            return false;
        }
        boolean accepted = this.acceptEvent(event);
        this.stateMachineExecutor.execute();
        if (!accepted) {
            this.notifyEventNotAccepted(this.buildStateContext(StateContext.Stage.EVENT_NOT_ACCEPTED, event, null, this.getRelayStateMachine(), this.getState(), null));
        }
        return accepted;
    }

    private StateMachine<S, E> getRelayStateMachine() {
        return this.relay != null ? this.relay : this;
    }

    public String toString() {
        ArrayList<State<S, E>> all = new ArrayList<State<S, E>>();
        for (State<S, E> s : this.states) {
            all.addAll(s.getStates());
        }
        StringBuilder buf = new StringBuilder();
        for (State state : all) {
            buf.append(state.getId() + " ");
        }
        buf.append(" / ");
        if (this.currentState != null) {
            buf.append(StringUtils.collectionToCommaDelimitedString(this.currentState.getIds()));
        }
        buf.append(" / uuid=");
        buf.append(this.uuid);
        buf.append(" / id=");
        buf.append(this.id);
        return buf.toString();
    }

    @Override
    public void resetStateMachine(StateMachineContext<S, E> stateMachineContext) {
        if (stateMachineContext == null) {
            log.info((Object)"Got null context, resetting to initial state, clearing extended state and machine id");
            this.currentState = this.initialState;
            this.extendedState.getVariables().clear();
            this.setId(null);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request to reset state machine: stateMachine=[" + this + "] stateMachineContext=[" + stateMachineContext + "]"));
        }
        this.setId(stateMachineContext.getId());
        S state = stateMachineContext.getState();
        boolean stateSet = false;
        for (State<S, E> s : this.getStates()) {
            block1: for (State<S, E> ss : s.getStates()) {
                Collection regions;
                boolean enumMatch = false;
                if (state instanceof Enum && ss.getId() instanceof Enum && state.getClass() == ss.getId().getClass() && ((Enum)ss.getId()).ordinal() == ((Enum)state).ordinal()) {
                    enumMatch = true;
                }
                if (state != null && (ss.getIds().contains(state) || enumMatch)) {
                    this.currentState = s;
                    this.lastState = this.currentState;
                    if (s.isSubmachineState()) {
                        StateMachine submachine = ((AbstractState)s).getSubmachine();
                        for (final StateMachineContext<S, E> stateMachineContext2 : stateMachineContext.getChilds()) {
                            submachine.getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                                @Override
                                public void apply(StateMachineAccess<S, E> function) {
                                    function.resetStateMachine(stateMachineContext2);
                                }
                            });
                        }
                    } else if (s.isOrthogonal() && stateMachineContext.getChilds() != null) {
                        regions = ((AbstractState)s).getRegions();
                        for (Region region : regions) {
                            for (final StateMachineContext<S, E> child : stateMachineContext.getChilds()) {
                                ((StateMachine)region).getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                                    @Override
                                    public void apply(StateMachineAccess<S, E> function) {
                                        function.resetStateMachine(child);
                                    }
                                });
                            }
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("State reseted: stateMachine=[" + this + "] stateMachineContext=[" + stateMachineContext + "]"));
                    }
                    stateSet = true;
                    break;
                }
                if (stateMachineContext.getChilds() == null || stateMachineContext.getChilds().isEmpty()) continue;
                if (s.isOrthogonal()) {
                    regions = ((AbstractState)s).getRegions();
                    for (Region region : regions) {
                        for (final StateMachineContext<S, E> child : stateMachineContext.getChilds()) {
                            if (!ObjectUtils.nullSafeEquals((Object)region.getId(), (Object)child.getId())) continue;
                            ((StateMachine)region).getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                                @Override
                                public void apply(StateMachineAccess<S, E> function) {
                                    function.resetStateMachine(child);
                                }
                            });
                        }
                    }
                    continue;
                }
                for (StateMachineContext stateMachineContext3 : stateMachineContext.getChilds()) {
                    Object s2 = stateMachineContext3.getState();
                    boolean enumMatch2 = false;
                    if (s2 instanceof Enum && ss.getId() instanceof Enum && state.getClass() == ss.getId().getClass() && ((Enum)ss.getId()).ordinal() == ((Enum)s2).ordinal()) {
                        enumMatch2 = true;
                    }
                    if (s2 == null || !ss.getIds().contains(s2) && !enumMatch2) continue;
                    this.currentState = s;
                    this.lastState = this.currentState;
                    stateSet = true;
                    continue block1;
                }
            }
            if (!stateSet) continue;
            break;
        }
        if (this.history != null && stateMachineContext.getHistoryStates() != null) {
            State h = null;
            for (State state2 : this.getStates()) {
                if (!state2.getId().equals(stateMachineContext.getHistoryStates().get(null))) continue;
                h = state2;
                break;
            }
            if (h != null) {
                ((HistoryPseudoState)this.history).setState(h);
            }
        }
        for (State<S, E> s : this.getStates()) {
            StateMachine stateMachine;
            PseudoState<S, E> submachineHistory;
            if (StateMachineUtils.isPseudoState(s, PseudoStateKind.JOIN)) {
                JoinPseudoState joinPseudoState = (JoinPseudoState)s.getPseudoState();
                Collection<S> ids = this.currentState.getIds();
                joinPseudoState.reset(ids);
            }
            if (!s.isSubmachineState() || (submachineHistory = ((AbstractStateMachine)(stateMachine = ((AbstractState)s).getSubmachine())).getHistoryState()) == null) continue;
            State h = null;
            for (State state3 : stateMachine.getStates()) {
                if (!state3.getId().equals(stateMachineContext.getHistoryStates().get(s.getId()))) continue;
                h = state3;
                break;
            }
            if (h == null) continue;
            ((HistoryPseudoState)submachineHistory).setState(h);
        }
        if (stateSet && stateMachineContext.getExtendedState() != null) {
            this.extendedState.getVariables().clear();
            this.extendedState.getVariables().putAll(stateMachineContext.getExtendedState().getVariables());
        }
        if (this.currentState instanceof Lifecycle) {
            ((Lifecycle)this.currentState).start();
        }
    }

    @Override
    public void addStateMachineInterceptor(StateMachineInterceptor<S, E> interceptor) {
        this.getStateMachineInterceptors().add(interceptor);
        this.stateMachineExecutor.addStateMachineInterceptor(interceptor);
    }

    @Override
    public void addStateMachineMonitor(StateMachineMonitor<S, E> monitor) {
        this.getStateMachineMonitor().register(monitor);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void executeTriggerlessTransitions(StateMachine<S, E> stateMachine, StateContext<S, E> stateContext, State<S, E> state) {
        this.stateMachineExecutor.executeTriggerlessTransitions(stateContext, state);
        State<S, E> cs = this.currentState;
        if (cs != null && cs.isOrthogonal()) {
            Collection regions = ((AbstractState)cs).getRegions();
            for (Region region : regions) {
                ((AbstractStateMachine)region).executeTriggerlessTransitions(this, stateContext, state);
            }
        } else if (cs != null && cs.isSubmachineState()) {
            StateMachine submachine = ((AbstractState)cs).getSubmachine();
            ((AbstractStateMachine)submachine).executeTriggerlessTransitions(this, stateContext, state);
        }
    }

    protected StateMachineExecutor<S, E> getStateMachineExecutor() {
        return this.stateMachineExecutor;
    }

    protected synchronized boolean acceptEvent(Message<E> message) {
        State<S, E> cs = this.currentState;
        if (cs != null && cs.shouldDefer(message)) {
            log.info((Object)("Current state " + cs + " deferred event " + message));
            this.stateMachineExecutor.queueDeferredEvent(message);
            return true;
        }
        if (cs != null && cs.sendEvent(message)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Queue event " + message + " " + this));
        }
        for (Transition<S, E> transition : this.transitions) {
            State<S, E> source = transition.getSource();
            Trigger trigger = transition.getTrigger();
            if (cs == null || !StateMachineUtils.containsAtleastOne(source.getIds(), cs.getIds()) || trigger == null || !trigger.evaluate(new DefaultTriggerContext(message.getPayload()))) continue;
            this.stateMachineExecutor.queueEvent(message);
            return true;
        }
        if (cs != null && cs.shouldDefer(message)) {
            log.info((Object)("Current state " + cs + " deferred event " + message));
            this.stateMachineExecutor.queueDeferredEvent(message);
            return true;
        }
        return false;
    }

    private boolean callPreStateChangeInterceptors(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        try {
            this.getStateMachineInterceptors().preStateChange(state, message, transition, this, stateMachine);
        }
        catch (Exception e) {
            log.info((Object)"Interceptors threw exception, skipping state change", (Throwable)e);
            return false;
        }
        return true;
    }

    private void callPostStateChangeInterceptors(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        try {
            this.getStateMachineInterceptors().postStateChange(state, message, transition, this, stateMachine);
        }
        catch (Exception e) {
            log.warn((Object)"Interceptors threw exception in post state change", (Throwable)e);
        }
    }

    private boolean isInitialTransition(Transition<S, E> transition) {
        return transition != null && transition.getKind() == TransitionKind.INITIAL;
    }

    private void switchToState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        PseudoStateKind kind;
        if (!(this.isInitialTransition(transition) || StateMachineUtils.isTransientPseudoState(state) || this.callPreStateChangeInterceptors(state, message, transition, stateMachine))) {
            return;
        }
        StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATE_CHANGED, message, transition, stateMachine);
        State<S, E> toState = this.followLinkedPseudoStates(state, stateContext);
        PseudoStateKind pseudoStateKind = kind = state.getPseudoState() != null ? state.getPseudoState().getKind() : null;
        if (kind != null && kind != PseudoStateKind.INITIAL && kind != PseudoStateKind.JOIN && kind != PseudoStateKind.FORK && kind != PseudoStateKind.END) {
            this.callPreStateChangeInterceptors(toState, message, transition, stateMachine);
        }
        PseudoStateKind pseudoStateKind2 = kind = toState.getPseudoState() != null ? toState.getPseudoState().getKind() : null;
        if (kind == PseudoStateKind.FORK) {
            this.exitCurrentState(toState, message, transition, stateMachine);
            ForkPseudoState fps = (ForkPseudoState)toState.getPseudoState();
            for (State ss : fps.getForks()) {
                this.callPreStateChangeInterceptors(ss, message, transition, stateMachine);
                this.setCurrentState(ss, message, transition, false, stateMachine, null, fps.getForks());
            }
        } else {
            ArrayList<State<S, State<S, E>>> targets = new ArrayList<State<S, State<S, E>>>();
            targets.add(toState);
            this.setCurrentState(toState, message, transition, true, stateMachine, null, targets);
        }
        this.stateMachineExecutor.execute();
        if (this.isComplete()) {
            this.stop();
        }
    }

    private State<S, E> followLinkedPseudoStates(State<S, E> state, StateContext<S, E> stateContext) {
        PseudoStateKind kind;
        PseudoStateKind pseudoStateKind = kind = state.getPseudoState() != null ? state.getPseudoState().getKind() : null;
        if (kind == PseudoStateKind.INITIAL || kind == PseudoStateKind.FORK) {
            return state;
        }
        if (kind != null) {
            State<S, E> toState = state.getPseudoState().entry(stateContext);
            if (toState == null) {
                return state;
            }
            return this.followLinkedPseudoStates(toState, stateContext);
        }
        return state;
    }

    private void registerPseudoStateListener() {
        for (State<S, E> state : this.states) {
            PseudoState p = state.getPseudoState();
            if (p == null) continue;
            ArrayList listeners = new ArrayList();
            listeners.add(new PseudoStateListener<S, E>(){

                @Override
                public void onContext(PseudoStateContext<S, E> context) {
                    PseudoState pseudoState = context.getPseudoState();
                    State toStateOrig = AbstractStateMachine.this.findStateWithPseudoState(pseudoState);
                    StateContext stateContext = AbstractStateMachine.this.buildStateContext(StateContext.Stage.STATE_EXIT, null, null, AbstractStateMachine.this.getRelayStateMachine());
                    State toState = AbstractStateMachine.this.followLinkedPseudoStates(toStateOrig, stateContext);
                    Transition transition = AbstractStateMachine.this.findTransition(toStateOrig, toState);
                    AbstractStateMachine.this.switchToState(toState, null, transition, AbstractStateMachine.this.getRelayStateMachine());
                    pseudoState.exit(stateContext);
                }
            });
            p.setPseudoStateListeners(listeners);
        }
    }

    private Transition<S, E> findTransition(State<S, E> from, State<S, E> to) {
        for (Transition<S, E> transition : this.transitions) {
            if (transition.getSource() != from || transition.getTarget() != to) continue;
            return transition;
        }
        return null;
    }

    private State<S, E> findStateWithPseudoState(PseudoState<S, E> pseudoState) {
        for (State<S, E> s : this.states) {
            if (s.getPseudoState() != pseudoState) continue;
            return s;
        }
        return null;
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, null, null, null);
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Exception exception) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, null, null, exception);
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, State<S, E> source, State<S, E> target) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, source, target, null);
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, null, null, sources, targets, null);
    }

    private State<S, E> findDeepParent(State<S, E> state) {
        for (State<S, E> s : this.states) {
            if (!s.getStates().contains(state)) continue;
            return s;
        }
        return null;
    }

    void setCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, boolean exit, StateMachine<S, E> stateMachine) {
        this.setCurrentState(state, message, transition, exit, stateMachine, null, null);
    }

    void setCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, boolean exit, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        this.setCurrentStateInternal(state, message, transition, exit, stateMachine, sources, targets);
    }

    private void setCurrentStateInternal(State<S, E> state, Message<E> message, Transition<S, E> transition, boolean exit, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        State<S, E> notifyFrom;
        State<S, E> findDeep = this.findDeepParent(state);
        boolean isTargetSubOf = false;
        if (transition != null && (isTargetSubOf = StateMachineUtils.isSubstate(state, transition.getSource())) && this.currentState == transition.getTarget()) {
            state = transition.getSource();
        }
        boolean nonDeepStatePresent = false;
        if (this.states.contains(state)) {
            if (exit) {
                try {
                    this.exitCurrentState(state, message, transition, stateMachine, sources, targets);
                }
                catch (Throwable t) {
                    log.error((Object)"Error calling exitCurrentState", t);
                }
            }
            notifyFrom = this.currentState;
            this.currentState = state;
            this.entryToState(state, message, transition, stateMachine);
            if (!StateMachineUtils.isPseudoState(state, PseudoStateKind.JOIN)) {
                this.notifyStateChanged(this.buildStateContext(StateContext.Stage.STATE_CHANGED, message, null, this.getRelayStateMachine(), notifyFrom, state));
            }
            nonDeepStatePresent = true;
            if (!this.isRunning() && !this.isComplete()) {
                this.start();
            }
        } else if (this.currentState == null && StateMachineUtils.isSubstate(findDeep, state)) {
            if (exit) {
                this.exitCurrentState(findDeep, message, transition, stateMachine, sources, targets);
            }
            notifyFrom = this.currentState;
            this.currentState = findDeep;
            this.entryToState(findDeep, message, transition, stateMachine);
            if (!StateMachineUtils.isPseudoState(state, PseudoStateKind.JOIN)) {
                this.notifyStateChanged(this.buildStateContext(StateContext.Stage.STATE_CHANGED, message, null, this.getRelayStateMachine(), notifyFrom, findDeep));
            }
            if (!this.isRunning() && !this.isComplete()) {
                this.start();
            }
        }
        if (this.currentState != null && !nonDeepStatePresent && findDeep != null) {
            boolean shouldTryEntry;
            if (exit) {
                this.exitCurrentState(state, message, transition, stateMachine, sources, targets);
            }
            if (this.currentState == findDeep) {
                if (this.currentState.isSubmachineState()) {
                    StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
                    if (!submachine.isComplete() && submachine.getState() == state && this.currentState == findDeep) {
                        if (isTargetSubOf) {
                            this.entryToState(this.currentState, message, transition, stateMachine);
                        }
                        this.currentState = findDeep;
                        ((AbstractStateMachine)submachine).setCurrentState(state, message, transition, false, stateMachine);
                        return;
                    }
                } else if (this.currentState.isOrthogonal()) {
                    Collection regions = ((AbstractState)this.currentState).getRegions();
                    for (Region region : regions) {
                        if (region.getState() != state || this.currentState != findDeep) continue;
                        if (isTargetSubOf) {
                            this.entryToState(this.currentState, message, transition, stateMachine);
                        }
                        this.currentState = findDeep;
                        ((AbstractStateMachine)region).setCurrentState(state, message, transition, false, stateMachine);
                        return;
                    }
                }
            }
            boolean bl = shouldTryEntry = findDeep != this.currentState;
            if (!shouldTryEntry && transition.getSource() == this.currentState && StateMachineUtils.isSubstate(this.currentState, transition.getTarget())) {
                shouldTryEntry = true;
            }
            this.currentState = findDeep;
            if (shouldTryEntry) {
                this.entryToState(this.currentState, message, transition, stateMachine, sources, targets);
            }
            if (this.currentState.isSubmachineState()) {
                StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
                ((AbstractStateMachine)submachine).setCurrentState(state, message, transition, false, stateMachine);
            } else if (this.currentState.isOrthogonal()) {
                Collection regions = ((AbstractState)this.currentState).getRegions();
                for (Region region : regions) {
                    ((AbstractStateMachine)region).setCurrentState(state, message, transition, false, stateMachine);
                }
            }
        }
        if (this.history != null && transition.getKind() != TransitionKind.INITIAL) {
            if (this.history.getKind() == PseudoStateKind.HISTORY_SHALLOW) {
                ((HistoryPseudoState)this.history).setState(findDeep);
            } else if (this.history.getKind() == PseudoStateKind.HISTORY_DEEP) {
                ((HistoryPseudoState)this.history).setState(state);
            }
        }
        if (stateMachine != this && this.isComplete()) {
            this.stop();
        }
    }

    void exitCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        this.exitCurrentState(state, message, transition, stateMachine, null, null);
    }

    void exitCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        if (this.currentState == null) {
            return;
        }
        if (this.currentState.isSubmachineState()) {
            StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
            ((AbstractStateMachine)submachine).exitCurrentState(state, message, transition, stateMachine);
            this.exitFromState(this.currentState, message, transition, stateMachine, sources, targets);
        } else if (this.currentState.isOrthogonal()) {
            Collection regions = ((AbstractState)this.currentState).getRegions();
            for (Region r : regions) {
                if (!r.getStates().contains(state)) continue;
                this.exitFromState(r.getState(), message, transition, stateMachine, sources, targets);
            }
            this.exitFromState(this.currentState, message, transition, stateMachine, sources, targets);
        } else {
            this.exitFromState(this.currentState, message, transition, stateMachine, sources, targets);
        }
    }

    private void exitFromState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        this.exitFromState(state, message, transition, stateMachine, null, null);
    }

    private void exitFromState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        if (state == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Trying Exit state=[" + state + "]"));
        }
        StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATE_EXIT, message, transition, stateMachine);
        if (transition != null) {
            State<S, E> findDeep = this.findDeepParent(transition.getTarget());
            boolean isTargetSubOfOtherState = findDeep != null && findDeep != this.currentState;
            boolean isSubOfSource = StateMachineUtils.isSubstate(transition.getSource(), this.currentState);
            boolean isSubOfTarget = StateMachineUtils.isSubstate(transition.getTarget(), this.currentState);
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getSource(), transition.getTarget()) && transition.getSource() == this.currentState) {
                return;
            }
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getTarget(), transition.getSource()) && transition.getTarget() == this.currentState) {
                return;
            }
            if (!(this.currentState == transition.getSource() && this.currentState == transition.getTarget() || !isSubOfSource && !isSubOfTarget && this.currentState == transition.getSource() || !isSubOfSource && !isSubOfTarget && this.currentState == transition.getTarget() || isTargetSubOfOtherState || !isSubOfSource && !isSubOfTarget && findDeep == null || !isSubOfSource && !isSubOfTarget && transition.getSource() == this.currentState && StateMachineUtils.isSubstate(this.currentState, transition.getTarget()))) {
                if (StateMachineUtils.isNormalPseudoState(transition.getTarget())) {
                    if (this.isPseudoStateSubstate(findDeep, targets)) {
                        return;
                    }
                    if (StateMachineUtils.isSubstate(this.currentState, transition.getTarget())) {
                        if (this.currentState.isSubmachineState() && StateMachineUtils.isPseudoState(transition.getTarget(), PseudoStateKind.FORK)) {
                            return;
                        }
                        if (this.currentState.isOrthogonal()) {
                            return;
                        }
                    }
                } else if (!(findDeep != null && findDeep != state && findDeep.getStates().contains(state) || isSubOfSource || isSubOfTarget)) {
                    return;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit state=[" + state + "]"));
        }
        state.exit(stateContext);
        this.notifyStateExited(this.buildStateContext(StateContext.Stage.STATE_EXIT, message, null, this.getRelayStateMachine(), state, null));
    }

    private boolean isPseudoStateSubstate(State<S, E> left, Collection<State<S, E>> rights) {
        if (rights == null || left == null) {
            return false;
        }
        for (State<S, E> s : rights) {
            if (!StateMachineUtils.isSubstate(left, s)) continue;
            return true;
        }
        return false;
    }

    private void entryToState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        this.entryToState(state, message, transition, stateMachine, null, null);
    }

    private void entryToState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        if (state == null) {
            return;
        }
        this.callPostStateChangeInterceptors(state, message, transition, stateMachine);
        log.debug((Object)("Trying Enter state=[" + state + "]"));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Trying Enter state=[" + state + "]"));
        }
        StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATE_ENTRY, message, transition, stateMachine, sources, targets);
        if (transition != null) {
            State<S, E> findDeep1 = this.findDeepParent(transition.getTarget());
            State<S, E> findDeep2 = this.findDeepParent(transition.getSource());
            boolean isComingFromOtherSubmachine = findDeep1 != null && findDeep2 != null && findDeep2 != this.currentState;
            boolean isSubOfSource = StateMachineUtils.isSubstate(transition.getSource(), this.currentState);
            boolean isSubOfTarget = StateMachineUtils.isSubstate(transition.getTarget(), this.currentState);
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getSource(), transition.getTarget()) && transition.getSource() == this.currentState) {
                return;
            }
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getTarget(), transition.getSource()) && transition.getTarget() == this.currentState) {
                return;
            }
            if ((this.currentState != transition.getSource() || this.currentState != transition.getTarget()) && (isSubOfSource || isSubOfTarget || this.currentState != transition.getTarget()) && !isComingFromOtherSubmachine && (isSubOfSource || isSubOfTarget || findDeep2 != null) && (isSubOfSource && !isSubOfTarget && this.currentState == transition.getTarget() ? AbstractStateMachine.isDirectSubstate(transition.getSource(), transition.getTarget()) && transition.getKind() != TransitionKind.LOCAL && AbstractStateMachine.isInitial(transition.getTarget()) : (isSubOfSource || isSubOfTarget || transition.getSource() != this.currentState || !StateMachineUtils.isSubstate(this.currentState, transition.getTarget())) && !isSubOfSource && !isSubOfTarget && !StateMachineUtils.isTransientPseudoState(transition.getTarget()))) {
                return;
            }
        }
        if (!StateMachineUtils.isPseudoState(state, PseudoStateKind.JOIN)) {
            this.notifyStateEntered(this.buildStateContext(StateContext.Stage.STATE_ENTRY, message, transition, this.getRelayStateMachine(), null, state));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter state=[" + state + "]"));
        }
        state.entry(stateContext);
    }

    private static <S, E> boolean isInitial(State<S, E> state) {
        return state.getPseudoState() != null && state.getPseudoState().getKind() == PseudoStateKind.INITIAL;
    }

    private static <S, E> boolean isDirectSubstate(State<S, E> left, State<S, E> right) {
        if (left != null && left.isSubmachineState()) {
            StateMachine submachine = ((AbstractState)left).getSubmachine();
            return submachine.getStates().contains(right);
        }
        return false;
    }
}

