/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.persist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.HistoryPseudoState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.AbstractStateMachine;
import org.springframework.statemachine.support.DefaultExtendedState;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.statemachine.support.Function;
import org.springframework.statemachine.support.StateMachineInterceptorAdapter;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.util.Assert;

public abstract class AbstractPersistingStateMachineInterceptor<S, E, T>
extends StateMachineInterceptorAdapter<S, E>
implements StateMachinePersist<S, E, T> {
    private static final Log log = LogFactory.getLog(AbstractPersistingStateMachineInterceptor.class);
    private Function<StateMachine<S, E>, Map<Object, Object>> extendedStateVariablesFunction = new AllVariablesFunction();

    @Override
    public void preStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("preStateChange with stateMachine " + stateMachine));
            log.debug((Object)("preStateChange with root stateMachine " + rootStateMachine));
            log.debug((Object)("preStateChange with state " + state));
        }
        try {
            this.write(this.buildStateMachineContext(stateMachine, rootStateMachine, state, message), stateMachine.getId());
        }
        catch (Exception e) {
            throw new StateMachineException("Unable to persist stateMachineContext", e);
        }
    }

    @Override
    public void postStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("postStateChange with stateMachine " + stateMachine));
            log.debug((Object)("postStateChange with root stateMachine " + rootStateMachine));
            log.debug((Object)("postStateChange with state " + state));
        }
        if (state != null && transition != null && transition.getKind() == TransitionKind.INITIAL) {
            try {
                this.write(this.buildStateMachineContext(stateMachine, rootStateMachine, state, message), stateMachine.getId());
            }
            catch (Exception e) {
                throw new StateMachineException("Unable to persist stateMachineContext", e);
            }
        }
    }

    @Override
    public abstract void write(StateMachineContext<S, E> var1, T var2) throws Exception;

    @Override
    public abstract StateMachineContext<S, E> read(T var1) throws Exception;

    public void setExtendedStateVariablesFunction(Function<StateMachine<S, E>, Map<Object, Object>> extendedStateVariablesFunction) {
        Assert.notNull(extendedStateVariablesFunction, (String)"'extendedStateVariablesFunction' cannot be null");
        this.extendedStateVariablesFunction = extendedStateVariablesFunction;
    }

    protected StateMachineContext<S, E> buildStateMachineContext(StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine, State<S, E> state) {
        return this.buildStateMachineContext(stateMachine, rootStateMachine, state, null);
    }

    protected StateMachineContext<S, E> buildStateMachineContext(StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine, State<S, E> state, Message<E> message) {
        DefaultExtendedState extendedState = new DefaultExtendedState();
        extendedState.getVariables().putAll(this.extendedStateVariablesFunction.apply(stateMachine));
        ArrayList childs = new ArrayList();
        ArrayList<String> childRefs = new ArrayList<String>();
        Object id = null;
        if (state.isSubmachineState()) {
            id = this.getDeepState(state);
        } else if (state.isOrthogonal()) {
            if (stateMachine.getState().isOrthogonal()) {
                Collection regions = ((AbstractState)state).getRegions();
                for (Region r : regions) {
                    childRefs.add(r.getId());
                }
            }
            id = state.getId();
        } else {
            id = state.getId();
        }
        HashMap historyStates = new HashMap();
        PseudoState historyState = ((AbstractStateMachine)stateMachine).getHistoryState();
        if (historyState != null) {
            historyStates.put(null, ((HistoryPseudoState)historyState).getState().getId());
        }
        Collection states = stateMachine.getStates();
        for (State ss : states) {
            State pss;
            StateMachine submachine;
            PseudoState ps;
            if (!ss.isSubmachineState() || (ps = ((AbstractStateMachine)(submachine = ((AbstractState)ss).getSubmachine())).getHistoryState()) == null || (pss = ((HistoryPseudoState)ps).getState()) == null) continue;
            historyStates.put(ss.getId(), pss.getId());
        }
        Object event = message != null ? message.getPayload() : null;
        MessageHeaders eventHeaders = message != null ? message.getHeaders() : null;
        return new DefaultStateMachineContext<Object, Object>((List<String>)childRefs, childs, id, event, (Map<String, Object>)eventHeaders, extendedState, historyStates, stateMachine.getId());
    }

    private S getDeepState(State<S, E> state) {
        Collection<S> ids1 = state.getIds();
        Object[] ids2 = ids1.toArray();
        return (S)ids2[ids2.length - 1];
    }

    private static class AllVariablesFunction<S, E>
    implements Function<StateMachine<S, E>, Map<Object, Object>> {
        private AllVariablesFunction() {
        }

        @Override
        public Map<Object, Object> apply(StateMachine<S, E> stateMachine) {
            return stateMachine.getExtendedState().getVariables();
        }
    }
}

