/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.persist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.access.StateMachineAccess;
import org.springframework.statemachine.access.StateMachineFunction;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.HistoryPseudoState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.AbstractStateMachine;
import org.springframework.statemachine.support.DefaultExtendedState;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.util.Assert;

public abstract class AbstractStateMachinePersister<S, E, T>
implements StateMachinePersister<S, E, T> {
    private final StateMachinePersist<S, E, T> stateMachinePersist;

    public AbstractStateMachinePersister(StateMachinePersist<S, E, T> stateMachinePersist) {
        Assert.notNull(stateMachinePersist, (String)"StateMachinePersist must be set");
        this.stateMachinePersist = stateMachinePersist;
    }

    @Override
    public final void persist(StateMachine<S, E> stateMachine, T contextObj) throws Exception {
        this.stateMachinePersist.write(this.buildStateMachineContext(stateMachine), contextObj);
    }

    @Override
    public final StateMachine<S, E> restore(StateMachine<S, E> stateMachine, T contextObj) throws Exception {
        final StateMachineContext<S, E> context = this.stateMachinePersist.read(contextObj);
        stateMachine.stop();
        stateMachine.getStateMachineAccessor().doWithAllRegions(new StateMachineFunction<StateMachineAccess<S, E>>(){

            @Override
            public void apply(StateMachineAccess<S, E> function) {
                function.resetStateMachine(context);
            }
        });
        stateMachine.start();
        return stateMachine;
    }

    protected StateMachineContext<S, E> buildStateMachineContext(StateMachine<S, E> stateMachine) {
        DefaultExtendedState extendedState = new DefaultExtendedState();
        extendedState.getVariables().putAll(stateMachine.getExtendedState().getVariables());
        ArrayList childs = new ArrayList();
        Object id = null;
        State state = stateMachine.getState();
        if (state.isSubmachineState()) {
            StateMachine submachine = ((AbstractState)state).getSubmachine();
            id = submachine.getState().getId();
            childs.add(this.buildStateMachineContext(submachine));
        } else if (state.isOrthogonal()) {
            Collection regions = ((AbstractState)state).getRegions();
            for (Region r : regions) {
                StateMachine rsm = (StateMachine)r;
                childs.add(this.buildStateMachineContext(rsm));
            }
            id = state.getId();
        } else {
            id = state.getId();
        }
        HashMap historyStates = new HashMap();
        PseudoState historyState = ((AbstractStateMachine)stateMachine).getHistoryState();
        if (historyState != null && ((HistoryPseudoState)historyState).getState() != null) {
            historyStates.put(null, ((HistoryPseudoState)historyState).getState().getId());
        }
        Collection states = stateMachine.getStates();
        for (State ss : states) {
            State pss;
            StateMachine submachine;
            PseudoState ps;
            if (!ss.isSubmachineState() || (ps = ((AbstractStateMachine)(submachine = ((AbstractState)ss).getSubmachine())).getHistoryState()) == null || (pss = ((HistoryPseudoState)ps).getState()) == null) continue;
            historyStates.put(ss.getId(), pss.getId());
        }
        return new DefaultStateMachineContext<Object, Object>(childs, id, null, null, extendedState, historyStates, stateMachine.getId());
    }
}

