/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.annotation.EventHeader;
import org.springframework.statemachine.annotation.EventHeaders;
import org.springframework.statemachine.annotation.ExtendedStateVariable;
import org.springframework.statemachine.processor.StateMachineRuntime;
import org.springframework.statemachine.support.AbstractExpressionEvaluator;
import org.springframework.statemachine.support.AnnotatedMethodFilter;
import org.springframework.statemachine.support.FixedMethodFilter;
import org.springframework.statemachine.support.UniqueMethodFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StateMachineMethodInvokerHelper<T, S, E>
extends AbstractExpressionEvaluator {
    private static final String CANDIDATE_METHODS = "CANDIDATE_METHODS";
    private static final String CANDIDATE_MESSAGE_METHODS = "CANDIDATE_MESSAGE_METHODS";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Object targetObject;
    private volatile String displayString;
    private volatile boolean requiresReply;
    private final Map<Class<?>, HandlerMethod> handlerMethods;
    private final Map<Class<?>, HandlerMethod> handlerMessageMethods;
    private final LinkedList<Map<Class<?>, HandlerMethod>> handlerMethodsList;
    private final HandlerMethod handlerMethod;
    private final Class<?> expectedType;

    public StateMachineMethodInvokerHelper(Object targetObject, Method method) {
        this(targetObject, method, null);
    }

    public StateMachineMethodInvokerHelper(Object targetObject, Method method, Class<?> expectedType) {
        this(targetObject, null, method, expectedType);
    }

    public StateMachineMethodInvokerHelper(Object targetObject, String methodName) {
        this(targetObject, methodName, null);
    }

    public StateMachineMethodInvokerHelper(Object targetObject, String methodName, Class<?> expectedType) {
        this(targetObject, null, methodName, expectedType);
    }

    public StateMachineMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType) {
        this(targetObject, annotationType, null);
    }

    public StateMachineMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Class<?> expectedType) {
        this(targetObject, annotationType, (String)null, expectedType);
    }

    public T process(StateMachineRuntime<S, E> stateMachineRuntime) throws Exception {
        ParametersWrapper<S, E> wrapper = new ParametersWrapper<S, E>(stateMachineRuntime.getStateContext());
        return this.processInternal(wrapper);
    }

    public String toString() {
        return this.displayString;
    }

    private StateMachineMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Method method, Class<?> expectedType) {
        Assert.notNull((Object)method, (String)"method must not be null");
        this.expectedType = expectedType;
        boolean bl = this.requiresReply = expectedType != null;
        if (expectedType != null) {
            Assert.isTrue((method.getReturnType() != Void.class && method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (String)"method must have a return type");
        }
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.targetObject = targetObject;
        this.handlerMethod = new HandlerMethod(method);
        this.handlerMethods = null;
        this.handlerMessageMethods = null;
        this.handlerMethodsList = null;
        try {
            this.prepareEvaluationContext(this.getEvaluationContext(false), method, annotationType);
        }
        catch (Exception e) {
            throw new StateMachineException("Unable to prepare evaluation context", e);
        }
        this.setDisplayString(targetObject, method);
    }

    private StateMachineMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, String methodName, Class<?> expectedType) {
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.expectedType = expectedType;
        this.targetObject = targetObject;
        this.requiresReply = expectedType != null;
        Map<String, Map<Class<?>, HandlerMethod>> handlerMethodsForTarget = this.findHandlerMethodsForTarget(targetObject, annotationType, methodName, this.requiresReply);
        Map<Class<?>, HandlerMethod> handlerMethods = handlerMethodsForTarget.get(CANDIDATE_METHODS);
        Map<Class<?>, HandlerMethod> handlerMessageMethods = handlerMethodsForTarget.get(CANDIDATE_MESSAGE_METHODS);
        if (handlerMethods.size() == 1 && handlerMessageMethods.isEmpty() || handlerMessageMethods.size() == 1 && handlerMethods.isEmpty()) {
            this.handlerMethod = handlerMethods.size() == 1 ? handlerMethods.values().iterator().next() : handlerMessageMethods.values().iterator().next();
            this.handlerMethods = null;
            this.handlerMessageMethods = null;
            this.handlerMethodsList = null;
        } else {
            this.handlerMethod = null;
            this.handlerMethods = handlerMethods;
            this.handlerMessageMethods = handlerMessageMethods;
            this.handlerMethodsList = new LinkedList();
            this.handlerMethodsList.add(this.handlerMethods);
            this.handlerMethodsList.add(this.handlerMessageMethods);
        }
        try {
            this.prepareEvaluationContext(this.getEvaluationContext(false), methodName, annotationType);
        }
        catch (Exception e) {
            throw new StateMachineException("Unable to prepare evaluation context", e);
        }
        this.setDisplayString(targetObject, methodName);
    }

    private void setDisplayString(Object targetObject, Object targetMethod) {
        StringBuilder sb = new StringBuilder(targetObject.getClass().getName());
        if (targetMethod instanceof Method) {
            sb.append("." + ((Method)targetMethod).getName());
        } else if (targetMethod instanceof String) {
            sb.append("." + targetMethod);
        }
        this.displayString = sb.toString() + "]";
    }

    private void prepareEvaluationContext(StandardEvaluationContext context, Object method, Class<? extends Annotation> annotationType) throws Exception {
        Class targetType = AopUtils.getTargetClass((Object)this.targetObject);
        if (method instanceof Method) {
            context.registerMethodFilter(targetType, (MethodFilter)new FixedMethodFilter((Method)method));
            if (this.expectedType != null) {
                Assert.state((boolean)context.getTypeConverter().canConvert(TypeDescriptor.valueOf(((Method)method).getReturnType()), TypeDescriptor.valueOf(this.expectedType)), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + method));
            }
        } else if (method == null || method instanceof String) {
            AnnotatedMethodFilter filter = new AnnotatedMethodFilter(annotationType, (String)method, this.requiresReply);
            Assert.state((boolean)this.canReturnExpectedType(filter, targetType, context.getTypeConverter()), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + method));
            context.registerMethodFilter(targetType, (MethodFilter)filter);
        }
        context.setVariable("target", this.targetObject);
        context.registerFunction("requiredHeader", ParametersWrapper.class.getDeclaredMethod("getHeader", Map.class, String.class));
    }

    private boolean canReturnExpectedType(AnnotatedMethodFilter filter, Class<?> targetType, TypeConverter typeConverter) {
        if (this.expectedType == null) {
            return true;
        }
        List<Method> methods = filter.filter(Arrays.asList(ReflectionUtils.getAllDeclaredMethods(targetType)));
        for (Method method : methods) {
            if (!typeConverter.canConvert(TypeDescriptor.valueOf(method.getReturnType()), TypeDescriptor.valueOf(this.expectedType))) continue;
            return true;
        }
        return false;
    }

    private T processInternal(ParametersWrapper<S, E> parameters) throws Exception {
        HandlerMethod candidate = this.findHandlerMethodForParameters(parameters);
        Assert.notNull((Object)candidate, (String)"No candidate methods found for messages.");
        Expression expression = candidate.getExpression();
        Class<?> expectedType = this.expectedType != null ? this.expectedType : candidate.method.getReturnType();
        try {
            Object result = this.evaluateExpression(expression, parameters, expectedType);
            if (this.requiresReply) {
                Assert.notNull(result, (String)"Expression evaluation result was null, but this processor requires a reply.");
            }
            return (T)result;
        }
        catch (Exception e) {
            Throwable evaluationException = e;
            if (e instanceof EvaluationException && e.getCause() != null) {
                evaluationException = e.getCause();
            }
            if (evaluationException instanceof Exception) {
                throw evaluationException;
            }
            throw new IllegalStateException("Cannot process message", evaluationException);
        }
    }

    private Map<String, Map<Class<?>, HandlerMethod>> findHandlerMethodsForTarget(Object targetObject, final Class<? extends Annotation> annotationType, final String methodName, final boolean requiresReply) {
        HashMap handlerMethods = new HashMap();
        final HashMap candidateMethods = new HashMap();
        final HashMap candidateMessageMethods = new HashMap();
        Class<?> targetClass = this.getTargetClass(targetObject);
        UniqueMethodFilter methodFilter = new UniqueMethodFilter(targetClass);
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                boolean matchesAnnotation = false;
                if (method.isBridge()) {
                    return;
                }
                if (StateMachineMethodInvokerHelper.isMethodDefinedOnObjectClass(method)) {
                    return;
                }
                if (method.getDeclaringClass().equals(Proxy.class)) {
                    return;
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    return;
                }
                if (requiresReply && Void.TYPE.equals(method.getReturnType())) {
                    return;
                }
                if (methodName != null && !methodName.equals(method.getName())) {
                    return;
                }
                if (annotationType != null && AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null) {
                    matchesAnnotation = true;
                }
                HandlerMethod handlerMethod = null;
                try {
                    handlerMethod = new HandlerMethod(method);
                }
                catch (Exception e) {
                    if (StateMachineMethodInvokerHelper.this.logger.isDebugEnabled()) {
                        StateMachineMethodInvokerHelper.this.logger.debug((Object)("Method [" + method + "] is not eligible for container handling."), (Throwable)e);
                    }
                    return;
                }
                Class<?> targetParameterType = handlerMethod.getTargetParameterType();
                if (matchesAnnotation || annotationType == null) {
                    if (handlerMethod.isMessageMethod()) {
                        if (candidateMessageMethods.containsKey(targetParameterType)) {
                            throw new IllegalArgumentException("Found more than one method match for type [Message<" + targetParameterType + ">]");
                        }
                        candidateMessageMethods.put(targetParameterType, handlerMethod);
                    } else {
                        if (candidateMethods.containsKey(targetParameterType)) {
                            String exceptionMessage = "Found more than one method match for ";
                            exceptionMessage = Void.class.equals(targetParameterType) ? exceptionMessage + "empty parameter for 'payload'" : exceptionMessage + "type [" + targetParameterType + "]";
                            throw new IllegalArgumentException(exceptionMessage);
                        }
                        candidateMethods.put(targetParameterType, handlerMethod);
                    }
                }
            }
        }, (ReflectionUtils.MethodFilter)methodFilter);
        if (!candidateMethods.isEmpty() || !candidateMessageMethods.isEmpty()) {
            handlerMethods.put(CANDIDATE_METHODS, candidateMethods);
            handlerMethods.put(CANDIDATE_MESSAGE_METHODS, candidateMessageMethods);
            return handlerMethods;
        }
        Assert.state((!handlerMethods.isEmpty() ? 1 : 0) != 0, (String)("Target object of type [" + this.targetObject.getClass() + "] has no eligible methods for handling Container."));
        return handlerMethods;
    }

    private Class<?> getTargetClass(Object targetObject) {
        Class superClass;
        Class targetClass = targetObject.getClass();
        if (AopUtils.isAopProxy((Object)targetObject)) {
            targetClass = AopUtils.getTargetClass((Object)targetObject);
            if (targetClass == targetObject.getClass()) {
                try {
                    Class[] interfaces = ((Advised)targetObject).getProxiedInterfaces();
                    if (interfaces != null && interfaces.length == 1) {
                        targetClass = interfaces[0];
                    }
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Exception trying to extract interface", (Throwable)e);
                    }
                }
            }
        } else if (ClassUtils.isCglibProxyClass(targetClass) && !Object.class.equals(superClass = targetObject.getClass().getSuperclass())) {
            targetClass = superClass;
        }
        return targetClass;
    }

    private HandlerMethod findHandlerMethodForParameters(ParametersWrapper<S, E> parameters) {
        if (this.handlerMethod != null) {
            return this.handlerMethod;
        }
        return this.handlerMethods.get(Void.class);
    }

    private static boolean isMethodDefinedOnObjectClass(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return true;
        }
        if (ReflectionUtils.isEqualsMethod((Method)method) || ReflectionUtils.isHashCodeMethod((Method)method) || ReflectionUtils.isToStringMethod((Method)method) || AopUtils.isFinalizeMethod((Method)method)) {
            return true;
        }
        return method.getName().equals("clone") && method.getParameterTypes().length == 0;
    }

    public static class ParametersWrapper<SS, EE> {
        private final StateContext<SS, EE> stateContext;

        public ParametersWrapper(StateContext<SS, EE> stateContext) {
            this.stateContext = stateContext;
        }

        public StateContext<SS, EE> getStateContext() {
            return this.stateContext;
        }

        public static Object getHeader(Map<?, ?> headers, String header) {
            Object object = headers.get(header);
            if (object == null) {
                throw new IllegalArgumentException("required header not available: " + header);
            }
            return object;
        }

        public Map<String, ?> getHeaders() {
            return this.stateContext.getMessageHeaders();
        }

        public ExtendedState getExtendedState() {
            return this.stateContext.getExtendedState();
        }

        public Map<Object, Object> getVariables() {
            return this.getExtendedState().getVariables();
        }

        public StateMachine<SS, EE> getStateMachine() {
            return this.stateContext.getStateMachine();
        }

        public Message<EE> getMessage() {
            return this.stateContext.getMessage();
        }

        public Exception getException() {
            return this.stateContext.getException();
        }
    }

    private static class HandlerMethod {
        private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
        private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new LocalVariableTableParameterNameDiscoverer();
        private final Method method;
        private final Expression expression;
        private volatile TypeDescriptor targetParameterTypeDescriptor;
        private volatile Class<?> targetParameterType = Void.class;
        private volatile boolean messageMethod;

        HandlerMethod(Method method) {
            this.method = method;
            this.expression = this.generateExpression(method);
        }

        Expression getExpression() {
            return this.expression;
        }

        Class<?> getTargetParameterType() {
            return this.targetParameterType;
        }

        private boolean isMessageMethod() {
            return this.messageMethod;
        }

        public String toString() {
            return this.method.toString();
        }

        private Expression generateExpression(Method method) {
            StringBuilder sb = new StringBuilder("#target." + method.getName() + "(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            boolean hasUnqualifiedMapParameter = false;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                MethodParameter methodParameter = new MethodParameter(method, i);
                TypeDescriptor parameterTypeDescriptor = new TypeDescriptor(methodParameter);
                Class parameterType = parameterTypeDescriptor.getObjectType();
                Annotation mappingAnnotation = this.findMappingAnnotation(parameterAnnotations[i]);
                if (mappingAnnotation != null) {
                    Class<? extends Annotation> annotationType = mappingAnnotation.annotationType();
                    if (annotationType.equals(EventHeaders.class)) {
                        sb.append("headers");
                        continue;
                    }
                    if (annotationType.equals(EventHeader.class)) {
                        sb.append(this.determineHeaderExpression(mappingAnnotation, methodParameter));
                        continue;
                    }
                    if (!annotationType.equals(ExtendedStateVariable.class)) continue;
                    AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((Annotation)mappingAnnotation));
                    String key = annotationAttributes.getString("value");
                    sb.append("variables.get('" + key + "')");
                    continue;
                }
                if (StateContext.class.isAssignableFrom(parameterType)) {
                    sb.append("stateContext");
                    continue;
                }
                if (ExtendedState.class.isAssignableFrom(parameterType)) {
                    sb.append("extendedState");
                    continue;
                }
                if (StateMachine.class.isAssignableFrom(parameterType)) {
                    sb.append("stateMachine");
                    continue;
                }
                if (Message.class.isAssignableFrom(parameterType)) {
                    sb.append("message");
                    continue;
                }
                if (!Exception.class.isAssignableFrom(parameterType)) continue;
                sb.append("exception");
            }
            if (hasUnqualifiedMapParameter && this.targetParameterType != null && Map.class.isAssignableFrom(this.targetParameterType)) {
                throw new IllegalArgumentException("Unable to determine payload matching parameter due to ambiguous Map typed parameters. Consider adding the @EventHeaders and or @ExtendedStateVariable annotations as appropriate.");
            }
            sb.append(")");
            if (this.targetParameterTypeDescriptor == null) {
                this.targetParameterTypeDescriptor = TypeDescriptor.valueOf(Void.class);
            }
            return EXPRESSION_PARSER.parseExpression(sb.toString());
        }

        private Annotation findMappingAnnotation(Annotation[] annotations) {
            if (annotations == null || annotations.length == 0) {
                return null;
            }
            Annotation match = null;
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> type = annotation.annotationType();
                if (type.equals(EventHeaders.class)) {
                    if (match != null) {
                        throw new IllegalArgumentException("At most one parameter annotation can be provided for message mapping, but found two: [" + match.annotationType().getName() + "] and [" + annotation.annotationType().getName() + "]");
                    }
                    match = annotation;
                    continue;
                }
                if (type.equals(EventHeader.class)) {
                    match = annotation;
                    continue;
                }
                if (!type.equals(ExtendedStateVariable.class)) continue;
                if (match != null) {
                    throw new IllegalArgumentException("At most one parameter annotation can be provided for message mapping, but found two: [" + match.annotationType().getName() + "] and [" + annotation.annotationType().getName() + "]");
                }
                match = annotation;
            }
            return match;
        }

        private String determineHeaderExpression(Annotation headerAnnotation, MethodParameter methodParameter) {
            methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
            String headerName = null;
            String relativeExpression = "";
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)AnnotationUtils.getAnnotationAttributes((Annotation)headerAnnotation);
            String valueAttribute = annotationAttributes.getString("value");
            if (!StringUtils.hasText((String)valueAttribute)) {
                headerName = methodParameter.getParameterName();
            } else if (valueAttribute.indexOf(46) != -1) {
                String[] tokens = valueAttribute.split("\\.", 2);
                headerName = tokens[0];
                if (StringUtils.hasText((String)tokens[1])) {
                    relativeExpression = "." + tokens[1];
                }
            } else {
                headerName = valueAttribute;
            }
            Assert.notNull((Object)headerName, (String)"Cannot determine header name. Possible reasons: -debug is disabled or header name is not explicitly provided via @EventHeader annotation.");
            String headerRetrievalExpression = "headers['" + headerName + "']";
            String fullHeaderExpression = headerRetrievalExpression + relativeExpression;
            if (annotationAttributes.getBoolean("required") && !methodParameter.getParameterType().getName().equals("java.util.Optional")) {
                return "#requiredHeader(headers, '" + headerName + "')" + relativeExpression;
            }
            if (!StringUtils.hasLength((String)relativeExpression)) {
                return headerRetrievalExpression + " ?: null";
            }
            return headerRetrievalExpression + " != null ? " + fullHeaderExpression + " : null";
        }
    }
}

