/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.statemachine.support.StateMachineContextUtils;

public abstract class ExpressionUtils {
    private static final Log logger = LogFactory.getLog(ExpressionUtils.class);

    private static StandardEvaluationContext createStandardEvaluationContext(ConversionService conversionService, BeanFactory beanFactory) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        if (conversionService != null) {
            evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        if (beanFactory != null) {
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        return evaluationContext;
    }

    public static StandardEvaluationContext createStandardEvaluationContext() {
        return ExpressionUtils.doCreateContext(null);
    }

    public static StandardEvaluationContext createStandardEvaluationContext(BeanFactory beanFactory) {
        if (beanFactory == null) {
            logger.warn((Object)"Creating EvaluationContext with no beanFactory", (Throwable)new RuntimeException("No beanfactory"));
        }
        return ExpressionUtils.doCreateContext(beanFactory);
    }

    private static StandardEvaluationContext doCreateContext(BeanFactory beanFactory) {
        ConversionService conversionService = null;
        StandardEvaluationContext evaluationContext = null;
        if (beanFactory != null) {
            evaluationContext = StateMachineContextUtils.getEvaluationContext(beanFactory);
        }
        if (evaluationContext == null) {
            if (beanFactory != null) {
                conversionService = StateMachineContextUtils.getConversionService(beanFactory);
            }
            evaluationContext = ExpressionUtils.createStandardEvaluationContext(conversionService, beanFactory);
        }
        return evaluationContext;
    }
}

