/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.transition.Transition;

public class StateMachineInterceptorList<S, E> {
    private final List<StateMachineInterceptor<S, E>> interceptors = new CopyOnWriteArrayList<StateMachineInterceptor<S, E>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(List<StateMachineInterceptor<S, E>> interceptors) {
        List<StateMachineInterceptor<S, E>> list = this.interceptors;
        synchronized (list) {
            this.interceptors.clear();
            return this.interceptors.addAll(interceptors);
        }
    }

    public boolean add(StateMachineInterceptor<S, E> interceptor) {
        return this.interceptors.add(interceptor);
    }

    public boolean remove(StateMachineInterceptor<S, E> interceptor) {
        return this.interceptors.remove(interceptor);
    }

    public Message<E> preEvent(Message<E> message, StateMachine<S, E> stateMachine) {
        StateMachineInterceptor<S, E> interceptor;
        Iterator<StateMachineInterceptor<S, E>> iterator = this.interceptors.iterator();
        while (iterator.hasNext() && (message = (interceptor = iterator.next()).preEvent(message, stateMachine)) != null) {
        }
        return message;
    }

    public void preStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
        for (StateMachineInterceptor<S, E> interceptor : this.interceptors) {
            interceptor.preStateChange(state, message, transition, stateMachine, rootStateMachine);
        }
    }

    public void postStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
        for (StateMachineInterceptor<S, E> interceptor : this.interceptors) {
            interceptor.postStateChange(state, message, transition, stateMachine, rootStateMachine);
        }
    }

    public StateContext<S, E> preTransition(StateContext<S, E> stateContext) {
        StateMachineInterceptor<S, E> interceptor;
        Iterator<StateMachineInterceptor<S, E>> iterator = this.interceptors.iterator();
        while (iterator.hasNext() && (stateContext = (interceptor = iterator.next()).preTransition(stateContext)) != null) {
        }
        return stateContext;
    }

    public StateContext<S, E> postTransition(StateContext<S, E> stateContext) {
        StateMachineInterceptor<S, E> interceptor;
        Iterator<StateMachineInterceptor<S, E>> iterator = this.interceptors.iterator();
        while (iterator.hasNext() && (stateContext = (interceptor = iterator.next()).postTransition(stateContext)) != null) {
        }
        return stateContext;
    }

    public Exception stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
        StateMachineInterceptor<S, E> interceptor;
        Iterator<StateMachineInterceptor<S, E>> iterator = this.interceptors.iterator();
        while (iterator.hasNext() && (exception = (interceptor = iterator.next()).stateMachineError(stateMachine, exception)) != null) {
        }
        return exception;
    }

    public String toString() {
        return "StateMachineInterceptorList [interceptors=" + this.interceptors + "]";
    }
}

