/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.Actions;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.config.model.ChoiceData;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.EntryData;
import org.springframework.statemachine.config.model.ExitData;
import org.springframework.statemachine.config.model.HistoryData;
import org.springframework.statemachine.config.model.JunctionData;
import org.springframework.statemachine.config.model.MalformedConfigurationException;
import org.springframework.statemachine.config.model.StateData;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.config.model.StateMachineModelFactory;
import org.springframework.statemachine.config.model.TransitionData;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.statemachine.config.model.verifier.CompositeStateMachineModelVerifier;
import org.springframework.statemachine.config.model.verifier.StateMachineModelVerifier;
import org.springframework.statemachine.ensemble.DistributedStateMachine;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.monitor.StateMachineMonitor;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.security.StateMachineSecurityInterceptor;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.ChoicePseudoState;
import org.springframework.statemachine.state.DefaultPseudoState;
import org.springframework.statemachine.state.EntryPseudoState;
import org.springframework.statemachine.state.ExitPseudoState;
import org.springframework.statemachine.state.ForkPseudoState;
import org.springframework.statemachine.state.HistoryPseudoState;
import org.springframework.statemachine.state.JoinPseudoState;
import org.springframework.statemachine.state.JunctionPseudoState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.RegionState;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateHolder;
import org.springframework.statemachine.state.StateMachineState;
import org.springframework.statemachine.support.DefaultExtendedState;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineInterceptorAdapter;
import org.springframework.statemachine.support.tree.Tree;
import org.springframework.statemachine.support.tree.TreeTraverser;
import org.springframework.statemachine.transition.AbstractTransition;
import org.springframework.statemachine.transition.DefaultExternalTransition;
import org.springframework.statemachine.transition.DefaultInternalTransition;
import org.springframework.statemachine.transition.DefaultLocalTransition;
import org.springframework.statemachine.transition.InitialTransition;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.statemachine.trigger.EventTrigger;
import org.springframework.statemachine.trigger.TimerTrigger;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;

public abstract class AbstractStateMachineFactory<S, E>
extends LifecycleObjectSupport
implements StateMachineFactory<S, E>,
BeanNameAware {
    private final Log log = LogFactory.getLog(AbstractStateMachineFactory.class);
    private final StateMachineModel<S, E> defaultStateMachineModel;
    private final StateMachineModelFactory<S, E> stateMachineModelFactory;
    private Boolean contextEvents;
    private boolean handleAutostartup = false;
    private String beanName;
    private StateMachineMonitor<S, E> defaultStateMachineMonitor;

    public AbstractStateMachineFactory(StateMachineModel<S, E> defaultStateMachineModel, StateMachineModelFactory<S, E> stateMachineModelFactory) {
        this.stateMachineModelFactory = stateMachineModelFactory;
        this.defaultStateMachineModel = defaultStateMachineModel;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public StateMachine<S, E> getStateMachine() {
        return this.getStateMachine(null, null);
    }

    @Override
    public StateMachine<S, E> getStateMachine(String machineId) {
        return this.getStateMachine(null, machineId);
    }

    @Override
    public StateMachine<S, E> getStateMachine(UUID uuid) {
        return this.getStateMachine(uuid, null);
    }

    /*
     * WARNING - void declaration
     */
    public StateMachine<S, E> getStateMachine(UUID uuid, String machineId) {
        ArrayList<StateMachine<S, E>> machines = new ArrayList<StateMachine<S, E>>();
        StateMachineModel<S, E> stateMachineModel = this.resolveStateMachineModel(machineId);
        if (stateMachineModel.getConfigurationData().isVerifierEnabled()) {
            StateMachineModelVerifier<S, E> verifier = stateMachineModel.getConfigurationData().getVerifier();
            if (verifier == null) {
                verifier = new CompositeStateMachineModelVerifier();
            }
            verifier.verify(stateMachineModel);
        }
        DefaultExtendedState defaultExtendedState = new DefaultExtendedState();
        StateMachine<Object, E> machine = null;
        HashMap<S, RegionState<Object, E>> stateMap = new HashMap<S, RegionState<Object, E>>();
        Stack<MachineStackItem<S, E>> regionStack = new Stack<MachineStackItem<S, E>>();
        Stack<StateData<S, StateData<S, E>>> stateStack = new Stack<StateData<S, StateData<S, E>>>();
        HashMap<Object, StateMachine<S, E>> machineMap = new HashMap<Object, StateMachine<S, E>>();
        ArrayList<HolderListItem<S, E>> holderList = new ArrayList<HolderListItem<S, E>>();
        Iterator<Tree.Node<StateData<S, E>>> iterator = this.buildStateDataIterator(stateMachineModel);
        while (iterator.hasNext()) {
            Iterator peek;
            Tree.Node<StateData<S, E>> node = iterator.next();
            StateData<S, E> stateData = node.getData();
            Iterator iterator2 = peek = stateStack.isEmpty() ? null : (StateData)stateStack.peek();
            if (stateStack.isEmpty()) {
                stateStack.push(stateData);
                continue;
            }
            boolean bl = false;
            for (StateData stateData2 : stateStack) {
                if (stateData == null || !ObjectUtils.nullSafeEquals(stateData.getState(), (Object)stateData2.getParent())) continue;
                bl = true;
                break;
            }
            if (stateData != null && !bl) {
                stateStack.push(stateData);
                continue;
            }
            Collection<StateData<S, E>> collection = AbstractStateMachineFactory.popSameParents(stateStack);
            int initialCount = this.getInitialCount(collection);
            Collection<Collection<StateData<S, E>>> regionsStateDatas = this.splitIntoRegions(collection);
            Collection<TransitionData<S, E>> transitionsData = this.getTransitionData(iterator.hasNext(), collection, stateMachineModel);
            if (initialCount > 1) {
                for (Collection<StateData<S, E>> regionStateDatas : regionsStateDatas) {
                    Object rId = regionStateDatas.iterator().next().getRegion();
                    String mId = machineId != null ? machineId : stateMachineModel.getConfigurationData().getMachineId();
                    mId = mId + "#" + (rId != null ? rId.toString() : "");
                    machine = this.buildMachine(machineMap, stateMap, holderList, regionStateDatas, transitionsData, this.resolveBeanFactory(stateMachineModel), this.contextEvents, defaultExtendedState, stateMachineModel.getTransitionsData(), mId, null, stateMachineModel);
                    regionStack.push(new MachineStackItem<S, E>(machine));
                    machines.add(machine);
                }
                ArrayList regions = new ArrayList();
                while (!regionStack.isEmpty()) {
                    MachineStackItem pop = (MachineStackItem)regionStack.pop();
                    regions.add(pop.machine);
                }
                Object parent = ((StateData)((Object)peek)).getParent();
                RegionState<Object, E> rstate = this.buildRegionStateInternal(parent, regions, null, stateData != null ? stateData.getEntryActions() : null, stateData != null ? stateData.getExitActions() : null, new DefaultPseudoState(PseudoStateKind.INITIAL), stateMachineModel);
                rstate.setRegionExecutionPolicy(stateMachineModel.getConfigurationData().getRegionExecutionPolicy());
                if (stateData != null) {
                    stateMap.put(stateData.getState(), rstate);
                } else {
                    ArrayList<State<S, RegionState<Object, E>>> states = new ArrayList<State<S, RegionState<Object, E>>>();
                    states.add(rstate);
                    InitialTransition<Object, E> initialTransition = new InitialTransition<Object, E>(rstate);
                    StateMachine<Object, E> m = this.buildStateMachineInternal(states, new ArrayList<Transition<S, E>>(), rstate, initialTransition, null, defaultExtendedState, null, this.contextEvents, this.resolveBeanFactory(stateMachineModel), this.beanName, machineId != null ? machineId : stateMachineModel.getConfigurationData().getMachineId(), uuid, stateMachineModel);
                    machine = m;
                    machines.add(m);
                }
            } else {
                machine = this.buildMachine(machineMap, stateMap, holderList, collection, transitionsData, this.resolveBeanFactory(stateMachineModel), this.contextEvents, defaultExtendedState, stateMachineModel.getTransitionsData(), machineId, uuid, stateMachineModel);
                machines.add(machine);
                if (((StateData)((Object)peek)).isInitial() || !((StateData)((Object)peek)).isInitial() && !machineMap.containsKey(((StateData)((Object)peek)).getParent())) {
                    machineMap.put(((StateData)((Object)peek)).getParent(), machine);
                }
            }
            stateStack.push(stateData);
        }
        if (machine instanceof LifecycleObjectSupport) {
            ((LifecycleObjectSupport)((Object)machine)).setAutoStartup(stateMachineModel.getConfigurationData().isAutoStart());
        }
        StateMachine fmachine = machine;
        fmachine.getStateMachineAccessor().doWithAllRegions(function -> function.setRelay(fmachine));
        StateMachineMonitor<S, E> stateMachineMonitor = stateMachineModel.getConfigurationData().getStateMachineMonitor();
        if (stateMachineMonitor != null || this.defaultStateMachineMonitor != null) {
            fmachine.getStateMachineAccessor().doWithRegion(function -> {
                if (this.defaultStateMachineMonitor != null) {
                    function.addStateMachineMonitor(this.defaultStateMachineMonitor);
                }
                if (stateMachineMonitor != null) {
                    function.addStateMachineMonitor(stateMachineMonitor);
                }
            });
        }
        for (Map.Entry entry : machineMap.entrySet()) {
            void var17_27;
            Object var17_25 = null;
            if (entry.getKey() != null) {
                void var18_38;
                Object var18_36 = null;
                for (StateData<S, E> sd : stateMachineModel.getStatesData().getStateData()) {
                    if (!ObjectUtils.nullSafeEquals(sd.getState(), entry.getKey())) continue;
                    Object object = sd.getParent();
                    break;
                }
                StateMachine stateMachine = (StateMachine)machineMap.get(var18_38);
            }
            void var18_40 = var17_27;
            ((StateMachine)entry.getValue()).getStateMachineAccessor().doWithRegion(arg_0 -> AbstractStateMachineFactory.lambda$getStateMachine$2((StateMachine)var18_40, arg_0));
        }
        for (StateMachine stateMachine : machines) {
            ((LifecycleObjectSupport)((Object)stateMachine)).afterPropertiesSet();
        }
        if (stateMachineModel.getConfigurationData().isSecurityEnabled()) {
            StateMachineSecurityInterceptor securityInterceptor = new StateMachineSecurityInterceptor(stateMachineModel.getConfigurationData().getTransitionSecurityAccessDecisionManager(), stateMachineModel.getConfigurationData().getEventSecurityAccessDecisionManager(), stateMachineModel.getConfigurationData().getEventSecurityRule());
            this.log.info((Object)("Adding security interceptor " + securityInterceptor));
            fmachine.getStateMachineAccessor().doWithAllRegions(function -> function.addStateMachineInterceptor(securityInterceptor));
        }
        if (stateMachineModel.getConfigurationData().getStateMachineEnsemble() != null) {
            DistributedStateMachine<S, E> distributedStateMachine = new DistributedStateMachine<S, E>(stateMachineModel.getConfigurationData().getStateMachineEnsemble(), machine);
            distributedStateMachine.setAutoStartup(stateMachineModel.getConfigurationData().isAutoStart());
            distributedStateMachine.afterPropertiesSet();
            machine = distributedStateMachine;
        }
        for (StateMachineListener stateMachineListener : stateMachineModel.getConfigurationData().getStateMachineListeners()) {
            machine.addStateListener(stateMachineListener);
        }
        List<StateMachineInterceptor<S, E>> interceptors = stateMachineModel.getConfigurationData().getStateMachineInterceptors();
        if (interceptors != null) {
            for (StateMachineInterceptor<S, E> stateMachineInterceptor : interceptors) {
                RegionPersistingInterceptorAdapter<S, E> regionPersistingInterceptorAdapter = new RegionPersistingInterceptorAdapter<S, E>(stateMachineInterceptor);
                machine.getStateMachineAccessor().doWithAllRegions(function -> function.addStateMachineInterceptor(adapter));
            }
        }
        for (HolderListItem holderListItem : holderList) {
            holderListItem.value.setState((State)stateMap.get(holderListItem.key));
        }
        return this.delegateAutoStartup(machine);
    }

    public void setHandleAutostartup(boolean handleAutostartup) {
        this.handleAutostartup = handleAutostartup;
    }

    public void setContextEventsEnabled(Boolean contextEvents) {
        this.contextEvents = contextEvents;
    }

    public void setStateMachineMonitor(StateMachineMonitor<S, E> stateMachineMonitor) {
        this.defaultStateMachineMonitor = stateMachineMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateMachine<S, E> delegateAutoStartup(StateMachine<S, E> delegate) {
        if (this.handleAutostartup && delegate instanceof SmartLifecycle && ((SmartLifecycle)delegate).isAutoStartup()) {
            AutostartListener autostartListener = new AutostartListener();
            delegate.addStateListener(autostartListener);
            ((SmartLifecycle)delegate).start();
            try {
                autostartListener.latch.await(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.log.warn((Object)"Waited 30 seconds for machine to start as autostart was requested, machine may not be ready");
            }
            finally {
                delegate.removeStateListener(autostartListener);
            }
        }
        return delegate;
    }

    protected BeanFactory resolveBeanFactory(StateMachineModel<S, E> stateMachineModel) {
        if (stateMachineModel.getConfigurationData().getBeanFactory() != null) {
            return stateMachineModel.getConfigurationData().getBeanFactory();
        }
        return this.getBeanFactory();
    }

    protected StateMachineModel<S, E> resolveStateMachineModel(String machineId) {
        if (this.stateMachineModelFactory == null) {
            return this.defaultStateMachineModel;
        }
        StateMachineModel<S, E> m = this.stateMachineModelFactory.build(machineId);
        if (m.getConfigurationData() == null) {
            return new DefaultStateMachineModel<S, E>(this.defaultStateMachineModel.getConfigurationData(), m.getStatesData(), m.getTransitionsData());
        }
        return m;
    }

    private int getInitialCount(Collection<StateData<S, E>> stateDatas) {
        int count = 0;
        for (StateData<S, E> stateData : stateDatas) {
            if (!stateData.isInitial()) continue;
            ++count;
        }
        return count;
    }

    private Collection<Collection<StateData<S, E>>> splitIntoRegions(Collection<StateData<S, E>> stateDatas) {
        HashMap<Object, ArrayList<StateData<S, E>>> map = new HashMap<Object, ArrayList<StateData<S, E>>>();
        for (StateData<S, E> stateData : stateDatas) {
            ArrayList<StateData<S, E>> c = (ArrayList<StateData<S, E>>)map.get(stateData.getRegion());
            if (c == null) {
                c = new ArrayList<StateData<S, E>>();
            }
            c.add(stateData);
            map.put(stateData.getRegion(), c);
        }
        return map.values();
    }

    private Collection<TransitionData<S, E>> getTransitionData(boolean roots, Collection<StateData<S, E>> stateDatas, StateMachineModel<S, E> stateMachineModel) {
        if (roots) {
            return this.resolveTransitionData(stateMachineModel.getTransitionsData().getTransitions(), stateDatas);
        }
        return this.resolveTransitionData2(stateMachineModel.getTransitionsData().getTransitions());
    }

    private static <S, E> Collection<StateData<S, E>> popSameParents(Stack<StateData<S, E>> stack) {
        ArrayList<StateData<S, StateData<S, E>>> data = new ArrayList<StateData<S, StateData<S, E>>>();
        Object parent = null;
        if (!stack.isEmpty()) {
            parent = stack.peek().getParent();
        }
        while (!stack.isEmpty() && ObjectUtils.nullSafeEquals((Object)parent, (Object)stack.peek().getParent())) {
            data.add(stack.pop());
        }
        return data;
    }

    private Collection<TransitionData<S, E>> resolveTransitionData(Collection<TransitionData<S, E>> in, Collection<StateData<S, E>> stateDatas) {
        ArrayList<TransitionData<S, TransitionData>> out = new ArrayList<TransitionData<S, TransitionData>>();
        ArrayList<Object> states = new ArrayList<Object>();
        for (StateData<S, E> stateData : stateDatas) {
            states.add(stateData.getParent());
        }
        for (TransitionData transitionData : in) {
            Object state = transitionData.getState();
            if (state == null || !states.contains(state)) continue;
            out.add(transitionData);
        }
        return out;
    }

    private Collection<TransitionData<S, E>> resolveTransitionData2(Collection<TransitionData<S, E>> in) {
        ArrayList<TransitionData<S, TransitionData<S, E>>> out = new ArrayList<TransitionData<S, TransitionData<S, E>>>();
        for (TransitionData<S, E> transitionData : in) {
            if (transitionData.getState() != null) continue;
            out.add(transitionData);
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    private StateMachine<S, E> buildMachine(Map<Object, StateMachine<S, E>> machineMap, Map<S, State<S, E>> stateMap, List<HolderListItem<S, E>> holderList, Collection<StateData<S, E>> stateDatas, Collection<TransitionData<S, E>> transitionsData, BeanFactory beanFactory, Boolean contextEvents, DefaultExtendedState defaultExtendedState, TransitionsData<S, E> stateMachineTransitions, String machineId, UUID uuid, StateMachineModel<S, E> stateMachineModel) {
        State<S, E> state = null;
        State<S, E> initialState = null;
        Object historyState = null;
        Action initialAction = null;
        ArrayList<State<S, State<S, E>>> states = new ArrayList<State<S, State<S, E>>>();
        for (StateData<S, E> stateData : stateDatas) {
            DefaultPseudoState pseudoState;
            void var20_20;
            StateMachine<S, E> stateMachine;
            StateMachine<S, E> stateMachine2 = machineMap.get(stateData.getState());
            if (stateMachine2 == null && (stateMachine = stateData.getSubmachine()) == null && stateData.getSubmachineFactory() != null) {
                StateMachine stateMachine3 = stateData.getSubmachineFactory().getStateMachine(machineId);
            }
            if ((state = stateMap.get(stateData.getState())) != null) {
                states.add(state);
                if (!stateData.isInitial()) continue;
                initialState = state;
                continue;
            }
            if (var20_20 != null) {
                pseudoState = null;
                if (stateData.isInitial()) {
                    pseudoState = new DefaultPseudoState(PseudoStateKind.INITIAL);
                }
                StateMachineState stateMachineState = new StateMachineState(stateData.getState(), var20_20, stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), pseudoState);
                stateMachineState.setStateDoActionPolicy(stateMachineModel.getConfigurationData().getStateDoActionPolicy());
                stateMachineState.setStateDoActionPolicyTimeout(stateMachineModel.getConfigurationData().getStateDoActionPolicyTimeout());
                state = stateMachineState;
                if (stateDatas.size() > 1 && stateData.isInitial()) {
                    initialState = state;
                    initialAction = stateData.getInitialAction();
                } else if (stateDatas.size() == 1) {
                    initialState = state;
                    initialAction = stateData.getInitialAction();
                }
                states.add(state);
            } else {
                pseudoState = null;
                if (stateData.isInitial()) {
                    pseudoState = new DefaultPseudoState(PseudoStateKind.INITIAL);
                } else if (stateData.isEnd()) {
                    pseudoState = new DefaultPseudoState(PseudoStateKind.END);
                } else if (stateData.getPseudoStateKind() == PseudoStateKind.HISTORY_SHALLOW || stateData.getPseudoStateKind() == PseudoStateKind.HISTORY_DEEP || stateData.getPseudoStateKind() == PseudoStateKind.JOIN || stateData.getPseudoStateKind() == PseudoStateKind.FORK || stateData.getPseudoStateKind() == PseudoStateKind.CHOICE || stateData.getPseudoStateKind() == PseudoStateKind.JUNCTION || stateData.getPseudoStateKind() == PseudoStateKind.ENTRY || stateData.getPseudoStateKind() == PseudoStateKind.EXIT) continue;
                state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), pseudoState, stateMachineModel);
                if (stateData.isInitial()) {
                    initialState = state;
                    initialAction = stateData.getInitialAction();
                }
                states.add(state);
            }
            stateMap.put(stateData.getState(), state);
        }
        block1: for (StateData<S, E> stateData : stateDatas) {
            StateHolder<S, E> holder;
            List<Object> list;
            Object pseudoState;
            Collection<HistoryData<S, Object>> historys;
            if (stateData.getPseudoStateKind() == PseudoStateKind.HISTORY_SHALLOW) {
                void var20_26;
                Object var20_25 = null;
                Object s2 = stateData.getState();
                historys = stateMachineTransitions.getHistorys();
                if (historys == null) {
                    throw new MalformedConfigurationException("No transitions for state " + s2);
                }
                for (HistoryData<S, E> historyData : historys) {
                    if (!historyData.getSource().equals(s2)) continue;
                    State<S, E> state2 = stateMap.get(historyData.getTarget());
                }
                StateHolder stateHolder = new StateHolder(var20_26);
                StateHolder<S, E> stateHolder2 = new StateHolder<S, E>(stateMap.get(stateData.getParent()));
                if (stateHolder2.getState() == null) {
                    holderList.add(new HolderListItem<Object, E>(stateData.getParent(), stateHolder2));
                }
                HistoryPseudoState pseudoState2 = new HistoryPseudoState(PseudoStateKind.HISTORY_SHALLOW, stateHolder, stateHolder2);
                state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), pseudoState2, stateMachineModel);
                states.add(state);
                stateMap.put(stateData.getState(), state);
                historyState = pseudoState2;
            } else if (stateData.getPseudoStateKind() == PseudoStateKind.HISTORY_DEEP) {
                void var20_29;
                Object var20_28 = null;
                Object s = stateData.getState();
                historys = stateMachineTransitions.getHistorys();
                if (historys == null) {
                    throw new MalformedConfigurationException("No transitions for state " + s);
                }
                for (HistoryData<S, E> historyData : historys) {
                    if (!historyData.getSource().equals(s)) continue;
                    State<S, E> state3 = stateMap.get(historyData.getTarget());
                }
                StateHolder stateHolder = new StateHolder(var20_29);
                StateHolder<S, E> stateHolder3 = new StateHolder<S, E>(stateMap.get(stateData.getParent()));
                if (stateHolder3.getState() == null) {
                    holderList.add(new HolderListItem<Object, E>(stateData.getParent(), stateHolder3));
                }
                pseudoState = new HistoryPseudoState(PseudoStateKind.HISTORY_DEEP, stateHolder, stateHolder3);
                state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), (PseudoState<S, E>)pseudoState, stateMachineModel);
                states.add(state);
                stateMap.put(stateData.getState(), state);
                historyState = pseudoState;
            }
            if (stateData.getPseudoStateKind() == PseudoStateKind.CHOICE) {
                Object s = stateData.getState();
                list = stateMachineTransitions.getChoices().get(s);
                if (list == null) {
                    throw new MalformedConfigurationException("No transitions for state " + s);
                }
                ArrayList choices = new ArrayList();
                for (ChoiceData choiceData : list) {
                    holder = new StateHolder<S, E>(stateMap.get(choiceData.getTarget()));
                    if (holder.getState() == null) {
                        holderList.add(new HolderListItem(choiceData.getTarget(), holder));
                    }
                    choices.add(new ChoicePseudoState.ChoiceStateData<S, E>(holder, choiceData.getGuard(), Actions.from(choiceData.getActions())));
                }
                ChoicePseudoState choicePseudoState = new ChoicePseudoState(choices);
                state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), choicePseudoState, stateMachineModel);
                states.add(state);
                stateMap.put(stateData.getState(), state);
                continue;
            }
            if (stateData.getPseudoStateKind() == PseudoStateKind.JUNCTION) {
                Object s = stateData.getState();
                list = stateMachineTransitions.getJunctions().get(s);
                Iterator<ExitData<S, JunctionPseudoState.JunctionStateData<S, E>>> junctions = new ArrayList();
                if (list == null) {
                    throw new MalformedConfigurationException("No transitions for state " + s);
                }
                for (JunctionData junctionData : list) {
                    holder = new StateHolder<S, E>(stateMap.get(junctionData.getTarget()));
                    if (holder.getState() == null) {
                        holderList.add(new HolderListItem(junctionData.getTarget(), holder));
                    }
                    junctions.add((ExitData<S, JunctionPseudoState.JunctionStateData<S, E>>)((Object)new JunctionPseudoState.JunctionStateData<S, E>(holder, junctionData.getGuard(), Actions.from(junctionData.getActions()))));
                }
                JunctionPseudoState<S, E> junctionPseudoState = new JunctionPseudoState<S, E>(junctions);
                state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), junctionPseudoState, stateMachineModel);
                states.add(state);
                stateMap.put(stateData.getState(), state);
                continue;
            }
            if (stateData.getPseudoStateKind() == PseudoStateKind.ENTRY) {
                Object s = stateData.getState();
                Collection<EntryData<S, E>> entrys = stateMachineTransitions.getEntrys();
                if (entrys == null) {
                    throw new MalformedConfigurationException("No transitions for state " + s);
                }
                for (EntryData entryData : entrys) {
                    if (!s.equals(entryData.getSource())) continue;
                    EntryPseudoState<S, E> entryPseudoState = new EntryPseudoState<S, E>(stateMap.get(entryData.getTarget()));
                    state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), entryPseudoState, stateMachineModel);
                    states.add(state);
                    stateMap.put(stateData.getState(), state);
                    continue block1;
                }
                continue;
            }
            if (stateData.getPseudoStateKind() == PseudoStateKind.EXIT) {
                Object s = stateData.getState();
                Collection<ExitData<S, E>> exits = stateMachineTransitions.getExits();
                if (exits == null) {
                    throw new MalformedConfigurationException("No transitions for state " + s);
                }
                for (ExitData<S, E> exitData : exits) {
                    if (!s.equals(exitData.getSource())) continue;
                    StateHolder<S, E> stateHolder = new StateHolder<S, E>(stateMap.get(exitData.getTarget()));
                    if (stateHolder.getState() == null) {
                        holderList.add(new HolderListItem<S, E>(exitData.getTarget(), stateHolder));
                    }
                    pseudoState = new ExitPseudoState<S, E>(stateHolder);
                    state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), (PseudoState<S, E>)pseudoState, stateMachineModel);
                    states.add(state);
                    stateMap.put(stateData.getState(), state);
                    continue block1;
                }
                continue;
            }
            if (stateData.getPseudoStateKind() == PseudoStateKind.FORK) {
                Object s = stateData.getState();
                list = stateMachineTransitions.getForks().get(s);
                ArrayList forks = new ArrayList();
                if (list == null) {
                    throw new MalformedConfigurationException("No transitions for state " + s);
                }
                for (Object object : list) {
                    forks.add(stateMap.get(object));
                }
                ForkPseudoState forkPseudoState = new ForkPseudoState(forks);
                state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), forkPseudoState, stateMachineModel);
                states.add(state);
                stateMap.put(stateData.getState(), state);
                continue;
            }
            if (stateData.getPseudoStateKind() != PseudoStateKind.JOIN) continue;
            Object s = stateData.getState();
            list = stateMachineTransitions.getJoins().get(s);
            if (list == null) {
                throw new MalformedConfigurationException("No transitions for state " + s);
            }
            ArrayList joins = new ArrayList();
            if (list.size() == 1) {
                State<S, E> state4 = stateMap.get(list.get(0));
                if (state4 instanceof RegionState) {
                    Collection collection = ((RegionState)state4).getRegions();
                    for (Region region : collection) {
                        ArrayList j = new ArrayList();
                        Collection ss2 = region.getStates();
                        for (State ss3 : ss2) {
                            if (ss3.getPseudoState() == null || ss3.getPseudoState().getKind() != PseudoStateKind.END) continue;
                            j.add(ss3);
                        }
                        joins.add(j);
                    }
                }
            } else {
                for (Object object : list) {
                    joins.add(Collections.singletonList(stateMap.get(object)));
                }
            }
            ArrayList arrayList = new ArrayList();
            Collection<TransitionData<S, E>> collection = stateMachineTransitions.getTransitions();
            for (TransitionData transitionData : collection) {
                if (transitionData.getSource() != s) continue;
                StateHolder<S, E> holder3 = new StateHolder<S, E>(stateMap.get(transitionData.getTarget()));
                if (holder3.getState() == null) {
                    holderList.add(new HolderListItem(transitionData.getTarget(), holder3));
                }
                arrayList.add(new JoinPseudoState.JoinStateData<S, E>(holder3, transitionData.getGuard()));
            }
            pseudoState = new JoinPseudoState(joins, arrayList);
            state = this.buildStateInternal(stateData.getState(), stateData.getDeferred(), stateData.getEntryActions(), stateData.getExitActions(), stateData.getStateActions(), (PseudoState<S, E>)pseudoState, stateMachineModel);
            states.add(state);
            stateMap.put(stateData.getState(), state);
        }
        ArrayList<Transition<S, AbstractTransition>> transitions = new ArrayList<Transition<S, AbstractTransition>>();
        for (TransitionData transitionData : transitionsData) {
            AbstractTransition transition;
            void var26_95;
            Object source = transitionData.getSource();
            Object target = transitionData.getTarget();
            Object e = transitionData.getEvent();
            Long l = transitionData.getPeriod();
            Integer count = transitionData.getCount();
            Object var26_92 = null;
            if (e != null) {
                EventTrigger eventTrigger = new EventTrigger(e);
            } else if (l != null) {
                TimerTrigger t = new TimerTrigger(l, count != null ? count : 0);
                if (beanFactory != null) {
                    t.setBeanFactory(beanFactory);
                }
                TimerTrigger timerTrigger = t;
                ((AbstractState)stateMap.get(source)).getTriggers().add(timerTrigger);
            }
            if (transitionData.getKind() == TransitionKind.EXTERNAL) {
                if (stateMap.get(source) == null || stateMap.get(target) == null) continue;
                transition = new DefaultExternalTransition<S, E>(stateMap.get(source), stateMap.get(target), transitionData.getActions(), e, transitionData.getGuard(), var26_95, transitionData.getSecurityRule(), transitionData.getName());
                transitions.add(transition);
                continue;
            }
            if (transitionData.getKind() == TransitionKind.LOCAL) {
                if (stateMap.get(source) == null || stateMap.get(target) == null) continue;
                transition = new DefaultLocalTransition<S, E>(stateMap.get(source), stateMap.get(target), transitionData.getActions(), e, transitionData.getGuard(), var26_95, transitionData.getSecurityRule(), transitionData.getName());
                transitions.add(transition);
                continue;
            }
            if (transitionData.getKind() != TransitionKind.INTERNAL) continue;
            transition = new DefaultInternalTransition<S, E>(stateMap.get(source), transitionData.getActions(), e, transitionData.getGuard(), var26_95, transitionData.getSecurityRule(), transitionData.getName());
            transitions.add(transition);
        }
        if (stateMachineTransitions.getJoins() != null) {
            for (Map.Entry<S, List<S>> entry : stateMachineTransitions.getJoins().entrySet()) {
                if (stateMap.get(entry.getKey()) == null) continue;
                List<S> entryList = entry.getValue();
                for (S s : entryList) {
                    State<S, E> state5 = stateMap.get(s);
                    if (state5 == null || state5.isOrthogonal()) continue;
                    State<S, E> target = stateMap.get(entry.getKey());
                    DefaultExternalTransition<S, Object> defaultExternalTransition = new DefaultExternalTransition<S, Object>(state5, target, null, null, null, null, null);
                    transitions.add(defaultExternalTransition);
                }
            }
        }
        InitialTransition initialTransition = new InitialTransition(initialState, Actions.from(initialAction));
        StateMachine<S, E> stateMachine = this.buildStateMachineInternal((Collection<State<S, E>>)states, (Collection<Transition<S, E>>)transitions, initialState, initialTransition, null, defaultExtendedState, (PseudoState<S, E>)historyState, contextEvents, beanFactory, this.beanName, machineId != null ? machineId : stateMachineModel.getConfigurationData().getMachineId(), uuid, stateMachineModel);
        return stateMachine;
    }

    protected abstract StateMachine<S, E> buildStateMachineInternal(Collection<State<S, E>> var1, Collection<Transition<S, E>> var2, State<S, E> var3, Transition<S, E> var4, Message<E> var5, ExtendedState var6, PseudoState<S, E> var7, Boolean var8, BeanFactory var9, String var10, String var11, UUID var12, StateMachineModel<S, E> var13);

    protected abstract State<S, E> buildStateInternal(S var1, Collection<E> var2, Collection<Function<StateContext<S, E>, Mono<Void>>> var3, Collection<Function<StateContext<S, E>, Mono<Void>>> var4, Collection<Function<StateContext<S, E>, Mono<Void>>> var5, PseudoState<S, E> var6, StateMachineModel<S, E> var7);

    private Iterator<Tree.Node<StateData<S, E>>> buildStateDataIterator(StateMachineModel<S, E> stateMachineModel) {
        Tree<StateData<S, E>> tree = new Tree<StateData<S, E>>();
        this.treeAdd(tree, stateMachineModel.getStatesData().getStateData());
        return new TreeTraverser<Tree.Node<StateData<S, E>>>(){

            @Override
            public Iterable<Tree.Node<StateData<S, E>>> children(Tree.Node<StateData<S, E>> root) {
                return root.getChildren();
            }
        }.postOrderTraversal(tree.getRoot()).iterator();
    }

    private void treeAdd(Tree<StateData<S, E>> tree, Collection<StateData<S, E>> stateDatas) {
        if (stateDatas == null) {
            return;
        }
        for (StateData<S, E> stateData : stateDatas) {
            tree.add(stateData, stateData.getState(), stateData.getParent());
            this.treeAdd(tree, stateData.getSubmachineStateData());
        }
    }

    protected abstract RegionState<S, E> buildRegionStateInternal(S var1, Collection<Region<S, E>> var2, Collection<E> var3, Collection<Function<StateContext<S, E>, Mono<Void>>> var4, Collection<Function<StateContext<S, E>, Mono<Void>>> var5, PseudoState<S, E> var6, StateMachineModel<S, E> var7);

    private static class HolderListItem<S, E> {
        S key;
        StateHolder<S, E> value;

        public HolderListItem(S key, StateHolder<S, E> value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class AutostartListener<S, E>
    extends StateMachineListenerAdapter<S, E> {
        final CountDownLatch latch = new CountDownLatch(1);

        private AutostartListener() {
        }

        @Override
        public void stateMachineStarted(StateMachine<S, E> stateMachine) {
            this.latch.countDown();
        }
    }

    private static class MachineStackItem<S, E> {
        StateMachine<S, E> machine;

        public MachineStackItem(StateMachine<S, E> machine) {
            this.machine = machine;
        }
    }

    private static class RegionPersistingInterceptorAdapter<S, E>
    extends StateMachineInterceptorAdapter<S, E> {
        private final StateMachineInterceptor<S, E> interceptor;

        public RegionPersistingInterceptorAdapter(StateMachineInterceptor<S, E> interceptor) {
            this.interceptor = interceptor;
        }

        @Override
        public Message<E> preEvent(Message<E> message, StateMachine<S, E> stateMachine) {
            return this.interceptor.preEvent(message, stateMachine);
        }

        @Override
        public StateContext<S, E> preTransition(StateContext<S, E> stateContext) {
            return this.interceptor.preTransition(stateContext);
        }

        @Override
        public StateContext<S, E> postTransition(StateContext<S, E> stateContext) {
            return this.interceptor.postTransition(stateContext);
        }

        @Override
        public Exception stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
            return this.interceptor.stateMachineError(stateMachine, exception);
        }

        @Override
        public void preStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
            this.interceptor.preStateChange(state, message, transition, stateMachine, rootStateMachine);
        }

        @Override
        public void postStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
            this.interceptor.postStateChange(state, message, transition, stateMachine, rootStateMachine);
        }
    }
}

