/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configuration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.config.EnableStateMachine;
import org.springframework.statemachine.config.ObjectStateMachineFactory;
import org.springframework.statemachine.config.StateMachineConfig;
import org.springframework.statemachine.config.StateMachineConfigurerAdapter;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.config.builders.StateMachineConfigBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurer;
import org.springframework.statemachine.config.common.annotation.AbstractImportingAnnotationConfiguration;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurer;
import org.springframework.statemachine.monitor.StateMachineMonitor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class StateMachineConfiguration<S, E>
extends AbstractImportingAnnotationConfiguration<StateMachineConfigBuilder<S, E>, StateMachineConfig<S, E>> {
    private final StateMachineConfigBuilder<S, E> builder = new StateMachineConfigBuilder();

    @Override
    protected BeanDefinition buildBeanDefinition(AnnotationMetadata importingClassMetadata, Class<? extends Annotation> namedAnnotation) throws Exception {
        String scope;
        String enableStateMachineEnclosingClassName = importingClassMetadata.getClassName();
        Class enableStateMachineEnclosingClass = ClassUtils.forName((String)enableStateMachineEnclosingClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
        if (!ClassUtils.isAssignable(StateMachineConfigurer.class, (Class)enableStateMachineEnclosingClass)) {
            return null;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(StateMachineDelegatingFactoryBean.class);
        AnnotationAttributes esmAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableStateMachine.class.getName(), false));
        Boolean contextEvents = esmAttributes.getBoolean("contextEvents");
        AnnotationAttributes scopeAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(Scope.class.getName(), false));
        if (scopeAttributes != null && StringUtils.hasText((String)(scope = scopeAttributes.getString("value")))) {
            beanDefinitionBuilder.setScope(scope);
        }
        beanDefinitionBuilder.addConstructorArgValue(this.builder);
        beanDefinitionBuilder.addConstructorArgValue(StateMachine.class);
        beanDefinitionBuilder.addConstructorArgValue((Object)importingClassMetadata.getClassName());
        beanDefinitionBuilder.addConstructorArgValue((Object)contextEvents);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
        ResolvableType type = this.resolveFactoryObjectType(enableStateMachineEnclosingClass);
        if (type != null && beanDefinition instanceof RootBeanDefinition) {
            ((RootBeanDefinition)beanDefinition).setTargetType(type);
        }
        return beanDefinition;
    }

    @Override
    protected List<Class<? extends Annotation>> getAnnotations() {
        ArrayList<Class<? extends Annotation>> types = new ArrayList<Class<? extends Annotation>>();
        types.add(EnableStateMachine.class);
        return types;
    }

    private ResolvableType resolveFactoryObjectType(Class<?> enableStateMachineEnclosingClass) {
        ResolvableType type = null;
        try {
            Class[] generics = ResolvableType.forClass(enableStateMachineEnclosingClass).as(StateMachineConfigurerAdapter.class).resolveGenerics();
            if (generics != null && generics.length == 2) {
                type = ResolvableType.forClassWithGenerics(StateMachine.class, (Class[])generics);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private static class StateMachineDelegatingFactoryBean<S, E>
    extends AbstractImportingAnnotationConfiguration.BeanDelegatingFactoryBean<StateMachine<S, E>, StateMachineConfigBuilder<S, E>, StateMachineConfig<S, E>>
    implements SmartLifecycle,
    BeanNameAware,
    BeanClassLoaderAware {
        private String clazzName;
        private Boolean contextEvents;
        private SmartLifecycle lifecycle;
        private DisposableBean disposableBean;
        private String beanName;
        private StateMachineMonitor<S, E> stateMachineMonitor;
        private ClassLoader classLoader;

        public StateMachineDelegatingFactoryBean(StateMachineConfigBuilder<S, E> builder, Class<StateMachine<S, E>> clazz, String clazzName, Boolean contextEvents) {
            super(builder, clazz);
            this.clazzName = clazzName;
            this.contextEvents = contextEvents;
        }

        public void setBeanName(String name) {
            this.beanName = name;
        }

        public void setBeanClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void afterPropertiesSet() throws Exception {
            AnnotationConfigurer configurer = (AnnotationConfigurer)this.getBeanFactory().getBean(ClassUtils.forName((String)this.clazzName, (ClassLoader)this.classLoader));
            StateMachineConfigBuilder builder = (StateMachineConfigBuilder)this.getBuilder();
            builder.apply(configurer);
            ObjectStateMachineFactory<S, E> stateMachineFactory = StateMachineFactory.create(builder);
            stateMachineFactory.setBeanFactory(this.getBeanFactory());
            stateMachineFactory.setContextEventsEnabled(this.contextEvents);
            stateMachineFactory.setBeanName(this.beanName);
            stateMachineFactory.setHandleAutostartup(((StateMachineConfig)builder.getOrBuild()).stateMachineConfigurationConfig.isAutoStart());
            if (this.stateMachineMonitor != null) {
                stateMachineFactory.setStateMachineMonitor(this.stateMachineMonitor);
            }
            StateMachine stateMachine = stateMachineFactory.getStateMachine();
            this.lifecycle = (SmartLifecycle)stateMachine;
            this.disposableBean = (DisposableBean)stateMachine;
            this.setObject(stateMachine);
        }

        @Override
        public void destroy() throws Exception {
            this.disposableBean.destroy();
        }

        public void start() {
            this.lifecycle.start();
        }

        public void stop() {
            this.lifecycle.stop();
        }

        public boolean isRunning() {
            return this.lifecycle.isRunning();
        }

        public int getPhase() {
            return 0;
        }

        public boolean isAutoStartup() {
            return this.lifecycle.isAutoStartup();
        }

        public void stop(Runnable callback) {
            this.lifecycle.stop(callback);
        }

        @Autowired(required=false)
        public void setStateMachineMonitor(StateMachineMonitor<S, E> stateMachineMonitor) {
            this.stateMachineMonitor = stateMachineMonitor;
        }
    }
}

