/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.statemachine.action.StateDoActionPolicy;
import org.springframework.statemachine.config.builders.StateMachineConfigurationBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.configurers.ConfigurationConfigurer;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.region.RegionExecutionPolicy;
import org.springframework.statemachine.transition.TransitionConflictPolicy;

public class DefaultConfigurationConfigurer<S, E>
extends AnnotationConfigurerAdapter<ConfigurationData<S, E>, StateMachineConfigurationConfigurer<S, E>, StateMachineConfigurationBuilder<S, E>>
implements ConfigurationConfigurer<S, E> {
    private String machineId;
    private BeanFactory beanFactory;
    private boolean autoStart = false;
    private TransitionConflictPolicy transitionConflightPolicy;
    private StateDoActionPolicy stateDoActionPolicy;
    private Long stateDoActionPolicyTimeout;
    private RegionExecutionPolicy regionExecutionPolicy;
    private final List<StateMachineListener<S, E>> listeners = new ArrayList<StateMachineListener<S, E>>();

    @Override
    public void configure(StateMachineConfigurationBuilder<S, E> builder) throws Exception {
        builder.setMachineId(this.machineId);
        builder.setBeanFactory(this.beanFactory);
        builder.setAutoStart(this.autoStart);
        builder.setStateMachineListeners(this.listeners);
        builder.setTransitionConflictPolicy(this.transitionConflightPolicy);
        builder.setStateDoActionPolicy(this.stateDoActionPolicy, this.stateDoActionPolicyTimeout);
        builder.setRegionExecutionPolicy(this.regionExecutionPolicy);
    }

    @Override
    public ConfigurationConfigurer<S, E> machineId(String id) {
        this.machineId = id;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> autoStartup(boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> listener(StateMachineListener<S, E> listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> transitionConflictPolicy(TransitionConflictPolicy transitionConflightPolicy) {
        this.transitionConflightPolicy = transitionConflightPolicy;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> stateDoActionPolicy(StateDoActionPolicy stateDoActionPolicy) {
        this.stateDoActionPolicy = stateDoActionPolicy;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> stateDoActionPolicyTimeout(long timeout, TimeUnit unit) {
        this.stateDoActionPolicyTimeout = unit.toMillis(timeout);
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> regionExecutionPolicy(RegionExecutionPolicy regionExecutionPolicy) {
        this.regionExecutionPolicy = regionExecutionPolicy;
        return this;
    }
}

