/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.model;

import java.util.Collection;
import java.util.function.Function;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.state.PseudoStateKind;
import reactor.core.publisher.Mono;

public class StateData<S, E> {
    private Object parent;
    private Object region;
    private S state;
    private Collection<StateData<S, E>> submachineStateData;
    private StateMachine<S, E> submachine;
    private StateMachineFactory<S, E> submachineFactory;
    private Collection<E> deferred;
    private Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions;
    private Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions;
    private Collection<Function<StateContext<S, E>, Mono<Void>>> stateActions;
    private boolean initial = false;
    private Action<S, E> initialAction;
    private boolean end = false;
    private PseudoStateKind pseudoStateKind;

    public StateData(S state) {
        this(state, false);
    }

    public StateData(S state, boolean initial) {
        this(null, null, state, null, null, null, initial);
    }

    public StateData(Object parent, Object region, S state, boolean initial) {
        this(parent, region, state, null, null, null, initial);
    }

    public StateData(Object parent, Object region, S state, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions) {
        this(parent, region, state, deferred, entryActions, exitActions, false);
    }

    public StateData(Object parent, Object region, S state, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, boolean initial) {
        this(parent, region, state, deferred, entryActions, exitActions, initial, null);
    }

    public StateData(Object parent, Object region, S state, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, boolean initial, Action<S, E> initialAction) {
        this.state = state;
        this.deferred = deferred;
        this.entryActions = entryActions;
        this.exitActions = exitActions;
        this.parent = parent;
        this.region = region;
        this.initial = initial;
        this.initialAction = initialAction;
    }

    public S getState() {
        return this.state;
    }

    public Collection<StateData<S, E>> getSubmachineStateData() {
        return this.submachineStateData;
    }

    public void setSubmachineStateData(Collection<StateData<S, E>> submachineStateData) {
        this.submachineStateData = submachineStateData;
    }

    public StateMachine<S, E> getSubmachine() {
        return this.submachine;
    }

    public void setSubmachine(StateMachine<S, E> submachine) {
        this.submachine = submachine;
    }

    public StateMachineFactory<S, E> getSubmachineFactory() {
        return this.submachineFactory;
    }

    public void setSubmachineFactory(StateMachineFactory<S, E> submachineFactory) {
        this.submachineFactory = submachineFactory;
    }

    public void setSubmachine(StateMachineFactory<S, E> submachineFactory) {
        this.submachineFactory = submachineFactory;
    }

    public Collection<E> getDeferred() {
        return this.deferred;
    }

    public void setDeferred(Collection<E> deferred) {
        this.deferred = deferred;
    }

    public Collection<Function<StateContext<S, E>, Mono<Void>>> getEntryActions() {
        return this.entryActions;
    }

    public void setEntryActions(Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions) {
        this.entryActions = entryActions;
    }

    public Collection<Function<StateContext<S, E>, Mono<Void>>> getExitActions() {
        return this.exitActions;
    }

    public void setExitActions(Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions) {
        this.exitActions = exitActions;
    }

    public Collection<Function<StateContext<S, E>, Mono<Void>>> getStateActions() {
        return this.stateActions;
    }

    public void setStateActions(Collection<Function<StateContext<S, E>, Mono<Void>>> stateActions) {
        this.stateActions = stateActions;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getRegion() {
        return this.region;
    }

    public void setRegion(Object region) {
        this.region = region;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public void setInitialAction(Action<S, E> action) {
        this.initialAction = action;
    }

    public Action<S, E> getInitialAction() {
        return this.initialAction;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public PseudoStateKind getPseudoStateKind() {
        return this.pseudoStateKind;
    }

    public void setPseudoStateKind(PseudoStateKind pseudoStateKind) {
        this.pseudoStateKind = pseudoStateKind;
    }

    public String toString() {
        return "StateData [parent=" + this.parent + ", region=" + this.region + ", state=" + this.state + ", deferred=" + this.deferred + ", entryActions=" + this.entryActions + ", exitActions=" + this.exitActions + ", initial=" + this.initial + ", initialAction=" + this.initialAction + ", end=" + this.end + ", pseudoStateKind=" + (Object)((Object)this.pseudoStateKind) + "]";
    }
}

