/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.ensemble;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineEventResult;
import org.springframework.statemachine.access.StateMachineAccessor;
import org.springframework.statemachine.ensemble.EnsembleListener;
import org.springframework.statemachine.ensemble.StateMachineEnsemble;
import org.springframework.statemachine.ensemble.StateMachineEnsembleException;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DistributedStateMachine<S, E>
extends LifecycleObjectSupport
implements StateMachine<S, E> {
    private static final Log log = LogFactory.getLog(DistributedStateMachine.class);
    private final StateMachineEnsemble<S, E> ensemble;
    private final StateMachine<S, E> delegate;
    private final LocalEnsembleListener listener = new LocalEnsembleListener();
    private final LocalStateMachineInterceptor interceptor = new LocalStateMachineInterceptor();

    public DistributedStateMachine(StateMachineEnsemble<S, E> ensemble, StateMachine<S, E> delegate) {
        Assert.notNull(ensemble, (String)"State machine ensemble must be set");
        Assert.notNull(delegate, (String)"State machine delegate must be set");
        this.ensemble = ensemble;
        this.delegate = delegate;
    }

    @Override
    protected void onInit() throws Exception {
        this.delegate.getStateMachineAccessor().doWithRegion(function -> function.addStateMachineInterceptor(this.interceptor));
    }

    @Override
    protected Mono<Void> doPreStartReactively() {
        return Mono.defer(() -> {
            this.ensemble.addEnsembleListener(this.listener);
            this.ensemble.join(this);
            return Mono.empty();
        });
    }

    @Override
    protected Mono<Void> doPreStopReactively() {
        return Mono.defer(() -> {
            this.ensemble.removeEnsembleListener(this.listener);
            this.ensemble.leave(this);
            return Mono.empty();
        });
    }

    @Override
    public boolean sendEvent(Message<E> event) {
        return this.delegate.sendEvent(this.addMachineIdentifier().apply(event));
    }

    @Override
    public boolean sendEvent(E event) {
        return this.sendEvent((E)MessageBuilder.withPayload(event).build());
    }

    @Override
    public Flux<StateMachineEventResult<S, E>> sendEvent(Mono<Message<E>> event) {
        return this.delegate.sendEvent(event.map(this.addMachineIdentifier()));
    }

    @Override
    public Mono<List<StateMachineEventResult<S, E>>> sendEventCollect(Mono<Message<E>> event) {
        return this.delegate.sendEventCollect(event.map(this.addMachineIdentifier()));
    }

    @Override
    public Flux<StateMachineEventResult<S, E>> sendEvents(Flux<Message<E>> events) {
        return this.delegate.sendEvents(events.map(this.addMachineIdentifier()));
    }

    private Function<Message<E>, Message<E>> addMachineIdentifier() {
        return e -> MessageBuilder.fromMessage((Message)e).setHeader("_sm_id_", (Object)this.delegate.getUuid()).build();
    }

    @Override
    public State<S, E> getState() {
        return this.delegate.getState();
    }

    @Override
    public Collection<State<S, E>> getStates() {
        return this.delegate.getStates();
    }

    @Override
    public Collection<Transition<S, E>> getTransitions() {
        return this.delegate.getTransitions();
    }

    @Override
    public boolean isComplete() {
        return this.delegate.isComplete();
    }

    @Override
    public void setStateMachineError(Exception exception) {
        this.delegate.setStateMachineError(exception);
    }

    @Override
    public boolean hasStateMachineError() {
        return this.delegate.hasStateMachineError();
    }

    @Override
    public void addStateListener(StateMachineListener<S, E> listener) {
        this.delegate.addStateListener(listener);
    }

    @Override
    public void removeStateListener(StateMachineListener<S, E> listener) {
        this.delegate.removeStateListener(listener);
    }

    @Override
    public State<S, E> getInitialState() {
        return this.delegate.getInitialState();
    }

    @Override
    public ExtendedState getExtendedState() {
        return this.delegate.getExtendedState();
    }

    @Override
    public StateMachineAccessor<S, E> getStateMachineAccessor() {
        return this.delegate.getStateMachineAccessor();
    }

    @Override
    public UUID getUuid() {
        return this.delegate.getUuid();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    public String toString() {
        return "DistributedStateMachine [delegate=" + this.delegate + "]";
    }

    private class LocalEnsembleListener
    implements EnsembleListener<S, E> {
        private LocalEnsembleListener() {
        }

        @Override
        public void stateMachineJoined(StateMachine<S, E> stateMachine, StateMachineContext<S, E> context) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event stateMachineJoined stateMachine=[" + stateMachine + "] context=[" + context + "]"));
            }
            if (stateMachine != null && stateMachine == DistributedStateMachine.this) {
                DistributedStateMachine.this.delegate.stopReactively().block();
                DistributedStateMachine.this.setStateMachineError(null);
                if (context != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Joining with context " + context));
                    }
                    DistributedStateMachine.this.delegate.getStateMachineAccessor().doWithAllRegions(function -> {
                        Void cfr_ignored_0 = (Void)function.resetStateMachineReactively(context).block();
                    });
                }
                log.info((Object)("Requesting to start delegating state machine " + DistributedStateMachine.this.delegate));
                log.info((Object)("Delegating machine id " + DistributedStateMachine.this.delegate.getUuid()));
                DistributedStateMachine.this.delegate.startReactively().block();
            }
        }

        @Override
        public void stateMachineLeft(StateMachine<S, E> stateMachine, StateMachineContext<S, E> context) {
            if (stateMachine != null && stateMachine == DistributedStateMachine.this) {
                log.info((Object)("Requesting to stop delegating state machine " + DistributedStateMachine.this.delegate));
                DistributedStateMachine.this.delegate.stopReactively().block();
            }
        }

        @Override
        public void stateChanged(StateMachineContext<S, E> context) {
            if (!ObjectUtils.nullSafeEquals((Object)DistributedStateMachine.this.delegate.getUuid(), (Object)context.getEventHeaders().get("_sm_id_"))) {
                Message m = MessageBuilder.withPayload(context.getEvent()).copyHeaders(context.getEventHeaders()).build();
                DistributedStateMachine.this.delegate.sendEvent(Mono.just((Object)m)).subscribe();
            }
        }

        @Override
        public void ensembleError(StateMachineEnsembleException exception) {
            log.error((Object)"Ensemble error", (Throwable)((Object)exception));
            DistributedStateMachine.this.setStateMachineError((Exception)((Object)exception));
            throw exception;
        }

        @Override
        public void ensembleLeaderGranted(StateMachine<S, E> stateMachine) {
        }

        @Override
        public void ensembleLeaderRevoked(StateMachine<S, E> stateMachine) {
        }
    }

    private class LocalStateMachineInterceptor
    implements StateMachineInterceptor<S, E> {
        private LocalStateMachineInterceptor() {
        }

        @Override
        public Message<E> preEvent(Message<E> message, StateMachine<S, E> stateMachine) {
            return message;
        }

        @Override
        public void preStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received preStateChange from " + stateMachine + " for delegate " + DistributedStateMachine.this.delegate));
            }
            if (message != null && ObjectUtils.nullSafeEquals((Object)DistributedStateMachine.this.delegate.getUuid(), (Object)message.getHeaders().get((Object)"_sm_id_"))) {
                DistributedStateMachine.this.ensemble.setState(new DefaultStateMachineContext(transition.getTarget().getId(), message.getPayload(), (Map<String, Object>)message.getHeaders(), stateMachine.getExtendedState()));
            }
        }

        @Override
        public void postStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
        }

        @Override
        public StateContext<S, E> preTransition(StateContext<S, E> stateContext) {
            return stateContext;
        }

        @Override
        public StateContext<S, E> postTransition(StateContext<S, E> stateContext) {
            if (stateContext.getTransition() != null && stateContext.getTransition().getKind() == TransitionKind.INTERNAL && ObjectUtils.nullSafeEquals((Object)DistributedStateMachine.this.delegate.getUuid(), (Object)stateContext.getMessageHeader("_sm_id_"))) {
                StateMachineContext current = DistributedStateMachine.this.ensemble.getState();
                if (current != null) {
                    DistributedStateMachine.this.ensemble.setState(new DefaultStateMachineContext(current.getState(), stateContext.getEvent(), (Map<String, Object>)stateContext.getMessageHeaders(), stateContext.getStateMachine().getExtendedState()));
                } else if (stateContext.getStateMachine().getState() != null) {
                    DistributedStateMachine.this.ensemble.setState(new DefaultStateMachineContext(stateContext.getStateMachine().getState().getId(), stateContext.getEvent(), (Map<String, Object>)stateContext.getMessageHeaders(), stateContext.getStateMachine().getExtendedState()));
                }
            }
            return stateContext;
        }

        @Override
        public Exception stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
            return exception;
        }
    }
}

