/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.PseudoStateListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ChoicePseudoState<S, E>
implements PseudoState<S, E> {
    private static final Log log = LogFactory.getLog(ChoicePseudoState.class);
    private final List<ChoiceStateData<S, E>> choices;

    public ChoicePseudoState(List<ChoiceStateData<S, E>> choices) {
        this.choices = choices;
    }

    @Override
    public PseudoStateKind getKind() {
        return PseudoStateKind.CHOICE;
    }

    @Override
    public Mono<State<S, E>> entry(StateContext<S, E> context) {
        return Mono.defer(() -> {
            ChoiceStateData<S, E> csd = null;
            Iterator<ChoiceStateData<S, E>> iterator = this.choices.iterator();
            while (iterator.hasNext()) {
                ChoiceStateData<S, E> c;
                csd = c = iterator.next();
                if (((ChoiceStateData)c).guard == null || !this.evaluateInternal(((ChoiceStateData)c).guard, context)) continue;
                break;
            }
            return Mono.justOrEmpty(csd);
        }).flatMap(csd -> Flux.fromIterable(csd.getActions()).flatMap(a -> (Mono)a.apply(context)).then(Mono.just(csd.getState())));
    }

    @Override
    public Mono<Void> exit(StateContext<S, E> context) {
        return Mono.empty();
    }

    @Override
    public void addPseudoStateListener(PseudoStateListener<S, E> listener) {
    }

    @Override
    public void setPseudoStateListeners(List<PseudoStateListener<S, E>> listeners) {
    }

    private boolean evaluateInternal(Guard<S, E> guard, StateContext<S, E> context) {
        try {
            return guard.evaluate(context);
        }
        catch (Throwable t) {
            log.warn((Object)"Deny guard due to throw as GUARD should not error", t);
            return false;
        }
    }

    public static class ChoiceStateData<S, E> {
        private final StateHolder<S, E> state;
        private final Guard<S, E> guard;
        private final Collection<Function<StateContext<S, E>, Mono<Void>>> actions;

        public ChoiceStateData(StateHolder<S, E> state, Guard<S, E> guard, Collection<Function<StateContext<S, E>, Mono<Void>>> actions) {
            Assert.notNull(state, (String)"Holder must be set");
            this.state = state;
            this.guard = guard;
            this.actions = actions;
        }

        public StateHolder<S, E> getStateHolder() {
            return this.state;
        }

        public State<S, E> getState() {
            return this.state.getState();
        }

        public Guard<S, E> getGuard() {
            return this.guard;
        }

        public Collection<Function<StateContext<S, E>, Mono<Void>>> getActions() {
            return this.actions;
        }
    }
}

