/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.listener.AbstractCompositeListener;
import org.springframework.statemachine.state.StateListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeStateListener<S, E>
extends AbstractCompositeListener<StateListener<S, E>>
implements StateListener<S, E> {
    @Override
    public void onEntry(StateContext<S, E> context) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            ((StateListener)iterator.next()).onEntry(context);
        }
    }

    @Override
    public void onExit(StateContext<S, E> context) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            ((StateListener)iterator.next()).onExit(context);
        }
    }

    @Override
    public void onComplete(StateContext<S, E> context) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            ((StateListener)iterator.next()).onComplete(context);
        }
    }

    @Override
    public Mono<Void> doOnComplete(StateContext<S, E> context) {
        return Mono.defer(() -> {
            Iterator iterator = this.getListeners().reverse();
            Iterable iterable = () -> iterator;
            Stream stream = StreamSupport.stream(iterable.spliterator(), false);
            return Flux.fromStream(stream).flatMap(listener -> listener.doOnComplete(context)).then();
        });
    }
}

