/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.PseudoStateListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JunctionPseudoState<S, E>
implements PseudoState<S, E> {
    private static final Log log = LogFactory.getLog(JunctionPseudoState.class);
    private final List<JunctionStateData<S, E>> junctions;

    public JunctionPseudoState(List<JunctionStateData<S, E>> junctions) {
        this.junctions = junctions;
    }

    @Override
    public PseudoStateKind getKind() {
        return PseudoStateKind.JUNCTION;
    }

    @Override
    public Mono<State<S, E>> entry(StateContext<S, E> context) {
        return Mono.defer(() -> {
            JunctionStateData<S, E> jsd = null;
            Iterator<JunctionStateData<S, E>> iterator = this.junctions.iterator();
            while (iterator.hasNext()) {
                JunctionStateData<S, E> j;
                jsd = j = iterator.next();
                if (((JunctionStateData)j).guard == null || !this.evaluateInternal(((JunctionStateData)j).guard, context)) continue;
                break;
            }
            return Mono.justOrEmpty(jsd);
        }).flatMap(jsd -> Flux.fromIterable(jsd.getActions()).flatMap(a -> (Mono)a.apply(context)).then(Mono.just(jsd.getState())));
    }

    @Override
    public Mono<Void> exit(StateContext<S, E> context) {
        return Mono.empty();
    }

    @Override
    public void addPseudoStateListener(PseudoStateListener<S, E> listener) {
    }

    @Override
    public void setPseudoStateListeners(List<PseudoStateListener<S, E>> listeners) {
    }

    private boolean evaluateInternal(Guard<S, E> guard, StateContext<S, E> context) {
        try {
            return guard.evaluate(context);
        }
        catch (Throwable t) {
            log.warn((Object)"Deny guard due to throw as GUARD should not error", t);
            return false;
        }
    }

    public static class JunctionStateData<S, E> {
        private final StateHolder<S, E> state;
        private final Guard<S, E> guard;
        private final Collection<Function<StateContext<S, E>, Mono<Void>>> actions;

        public JunctionStateData(StateHolder<S, E> state, Guard<S, E> guard, Collection<Function<StateContext<S, E>, Mono<Void>>> actions) {
            Assert.notNull(state, (String)"Holder must be set");
            this.state = state;
            this.guard = guard;
            this.actions = actions;
        }

        public StateHolder<S, E> getStateHolder() {
            return this.state;
        }

        public State<S, E> getState() {
            return this.state.getState();
        }

        public Guard<S, E> getGuard() {
            return this.guard;
        }

        public Collection<Function<StateContext<S, E>, Mono<Void>>> getActions() {
            return this.actions;
        }
    }
}

