/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.support.StateMachineReactiveLifecycle;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

public class ReactiveLifecycleManager
implements StateMachineReactiveLifecycle {
    private static final Log log = LogFactory.getLog(ReactiveLifecycleManager.class);
    private final AtomicEnum state = new AtomicEnum(LifecycleState.STOPPED);
    private Sinks.Many<Mono<Void>> startRequestsSink;
    private Sinks.Many<Mono<Void>> stopRequestsSink;
    private Flux<Mono<Void>> startRequests;
    private Flux<Mono<Void>> stopRequests;
    private Supplier<Mono<Void>> preStartRequest;
    private Supplier<Mono<Void>> preStopRequest;
    private Supplier<Mono<Void>> postStartRequest;
    private Supplier<Mono<Void>> postStopRequest;
    private AtomicBoolean stopRequested = new AtomicBoolean();
    private Object owner;

    public ReactiveLifecycleManager(Supplier<Mono<Void>> preStartRequest, Supplier<Mono<Void>> preStopRequest, Supplier<Mono<Void>> postStartRequest, Supplier<Mono<Void>> postStopRequest) {
        this.preStartRequest = preStartRequest;
        this.preStopRequest = preStopRequest;
        this.postStartRequest = postStartRequest;
        this.postStopRequest = postStopRequest;
        this.startRequestsSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.stopRequestsSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.startRequests = this.startRequestsSink.asFlux().cache(1);
        this.stopRequests = this.stopRequestsSink.asFlux().cache(1);
    }

    @Override
    public Mono<Void> startReactively() {
        log.debug((Object)("Request startReactively " + this));
        return Mono.defer(() -> Mono.just((Object)this.state.compareAndSet(LifecycleState.STOPPED, LifecycleState.STARTING)).filter(owns -> owns).flatMap(owns -> this.startRequests.next().flatMap(Function.identity()).doOnSuccess(aVoid -> this.state.set(LifecycleState.STARTED)))).then(Mono.defer(this.postStartRequest)).then(Mono.defer(() -> {
            if (this.stopRequested.compareAndSet(true, false)) {
                log.debug((Object)"Stopping as stopRequested is true");
                return this.stopReactively();
            }
            return Mono.empty();
        }));
    }

    @Override
    public Mono<Void> stopReactively() {
        log.debug((Object)("Request stopReactively " + this));
        return Mono.defer(() -> Mono.just((Object)this.state.compareAndSet(LifecycleState.STARTED, LifecycleState.STOPPING)).doOnNext(owns -> {
            if (!owns.booleanValue() && this.state.get() != LifecycleState.STOPPED) {
                log.debug((Object)("Don't own, requesting to postpone stop" + this));
                this.stopRequested.compareAndSet(false, true);
            }
        }).filter(owns -> owns).flatMap(owns -> this.stopRequests.next().flatMap(Function.identity()).doOnSuccess(aVoid -> this.state.set(LifecycleState.STOPPED)))).then(Mono.defer(this.postStopRequest));
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public LifecycleState getLifecycleState() {
        return this.state.get();
    }

    public boolean isRunning() {
        return this.state.get() == LifecycleState.STARTED;
    }

    public String toString() {
        return "[lifecyclestate=" + (Object)((Object)this.state.get()) + ", owner=" + this.owner + "]";
    }

    private class AtomicEnum {
        private final AtomicReference<LifecycleState> ref;

        public AtomicEnum(LifecycleState initialValue) {
            this.ref = new AtomicReference<LifecycleState>(initialValue);
        }

        public void set(LifecycleState newValue) {
            log.debug((Object)("Lifecycle to " + (Object)((Object)newValue) + " in " + ReactiveLifecycleManager.this));
            this.ref.set(newValue);
        }

        public LifecycleState get() {
            return this.ref.get();
        }

        public boolean compareAndSet(LifecycleState expect, LifecycleState update) {
            boolean set = this.ref.compareAndSet(expect, update);
            if (set) {
                log.debug((Object)("Lifecycle from " + (Object)((Object)expect) + " to " + (Object)((Object)update) + " in " + ReactiveLifecycleManager.this));
                if (update == LifecycleState.STARTING) {
                    log.debug((Object)("Next start request with doStartReactively in " + ReactiveLifecycleManager.this));
                    ReactiveLifecycleManager.this.startRequestsSink.emitNext(ReactiveLifecycleManager.this.preStartRequest.get(), Sinks.EmitFailureHandler.FAIL_FAST);
                } else if (update == LifecycleState.STOPPING) {
                    log.debug((Object)("Next stop request with doStopReactively in " + ReactiveLifecycleManager.this));
                    ReactiveLifecycleManager.this.stopRequestsSink.emitNext(ReactiveLifecycleManager.this.preStopRequest.get(), Sinks.EmitFailureHandler.FAIL_FAST);
                }
            }
            return set;
        }
    }

    public static enum LifecycleState {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

